/*
 * Decompiled with CFR 0.152.
 */
package me.xuxiaoxiao.xtools.common.log.logger.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.xuxiaoxiao.xtools.common.XTools;
import me.xuxiaoxiao.xtools.common.config.XConfigTools;
import me.xuxiaoxiao.xtools.common.config.configs.XConfigs;
import me.xuxiaoxiao.xtools.common.log.logger.XLogger;

public class XLoggerImpl
implements XLogger {
    public static final String CFG_LEVEL = "me.xuxiaoxiao$xtools-common$log.level";
    public static final String CFG_LEVEL_DEFAULT = "detail";
    public static final String CFG_REGEX = "me.xuxiaoxiao$xtools-common$log.regex";
    public static final String CFG_REGEX_DEFAULT = ".+";
    public static final String CFG_HANDLERS = "me.xuxiaoxiao$xtools-common$log.handlers";
    public static final String CFG_HANDLERS_DEFAULT = XConsoleHandler.class.getName() + "," + XFileHandler.class.getName();
    public static final String CFG_FORMATTER = "me.xuxiaoxiao$xtools-common$log.formatter";
    public static final String CFG_FORMATTER_DEFAULT = XLogFormatter.class.getName();
    public static final String CFG_CONSOLE_LEVEL = "me.xuxiaoxiao$xtools-common$log.console.level";
    public static final String CFG_CONSOLE_LEVEL_DEFAULT = "detail";
    public static final String CFG_FILE_LEVEL = "me.xuxiaoxiao$xtools-common$log.file.level";
    public static final String CFG_FILE_LEVEL_DEFAULT = "detail";
    public static final String CFG_FILE = "me.xuxiaoxiao$xtools-common$log.file.name";
    public static final String CFG_FILE_DEFAULT = "xlogger.log";
    public static final String CFG_FILE_APPEND = "me.xuxiaoxiao$xtools-common$log.file.append";
    public static final String CFG_FILE_APPEND_DEFAULT = "true";
    private final Logger logger = Logger.getLogger("xlog");
    private final ArrayList<XLogger.Handler> handlers = new ArrayList();
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private Pattern tagRegex;

    public XLoggerImpl() {
        this.logger.setUseParentHandlers(false);
        this.defaultLevel();
        this.defaultHandlers();
        this.defaultRegex();
        XTools.cfgWatch(CFG_REGEX, new XConfigs.Watcher(){

            @Override
            public void onCfgAdd(@Nonnull XConfigs configs, @Nonnull String key, @Nonnull String val) {
                XLoggerImpl.this.defaultRegex();
            }

            @Override
            public void onCfgDel(@Nonnull XConfigs configs, @Nonnull String key, @Nonnull String val) {
                XLoggerImpl.this.defaultRegex();
            }

            @Override
            public void onCfgChange(@Nonnull XConfigs configs, @Nonnull String key, @Nullable String valOld, @Nullable String valNew) {
                XLoggerImpl.this.defaultRegex();
            }
        });
    }

    protected void defaultLevel() {
        this.setLevel(XTools.cfgDef(CFG_LEVEL, "detail"));
    }

    protected void defaultRegex() {
        this.tagRegex = Pattern.compile(XTools.cfgDef(CFG_REGEX, CFG_REGEX_DEFAULT));
    }

    protected void defaultHandlers() {
        String handlersStr = XTools.cfgDef(CFG_HANDLERS, CFG_HANDLERS_DEFAULT);
        if (!XTools.strBlank(handlersStr)) {
            for (String handlerClass : handlersStr.split(",")) {
                this.addHandler((XLogger.Handler)XConfigTools.supply(handlerClass.trim()));
            }
        }
    }

    @Nonnull
    private static String buildMsg(@Nullable Throwable throwable, @Nonnull String msg) {
        StringBuilder sbMsg = new StringBuilder(msg);
        if (throwable != null) {
            sbMsg.append('\n').append(throwable.getMessage());
            for (StackTraceElement element : throwable.getStackTrace()) {
                sbMsg.append('\n').append(element.toString());
            }
        }
        return sbMsg.toString();
    }

    @Nonnull
    private static Level strToLevel(@Nullable String level) {
        if (XTools.strEmpty(level)) {
            return Level.ALL;
        }
        switch (level) {
            case "off": {
                return Level.OFF;
            }
            case "error": {
                return Level.SEVERE;
            }
            case "warning": {
                return Level.WARNING;
            }
            case "notice": {
                return Level.INFO;
            }
        }
        return Level.ALL;
    }

    @Nonnull
    private static String levelToStr(@Nullable Level level) {
        if (Level.OFF.equals(level)) {
            return "off";
        }
        if (Level.SEVERE.equals(level)) {
            return "error";
        }
        if (Level.WARNING.equals(level)) {
            return "warning";
        }
        if (Level.INFO.equals(level)) {
            return "notice";
        }
        return "detail";
    }

    @Override
    public void logE(@Nonnull String tag, @Nonnull String error) {
        this.logE(tag, null, error);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logE(@Nonnull String tag, @Nullable Throwable throwable, @Nonnull String error) {
        this.rwLock.readLock().lock();
        try {
            if (this.logger.isLoggable(XLoggerImpl.strToLevel("error")) && this.accept(tag)) {
                this.logger.log(Level.SEVERE, XLoggerImpl.buildMsg(throwable, error), tag);
            }
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    @Override
    public void logW(@Nonnull String tag, @Nonnull String warning) {
        this.logW(tag, null, warning);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logW(@Nonnull String tag, @Nullable Throwable throwable, @Nonnull String warning) {
        this.rwLock.readLock().lock();
        try {
            if (this.logger.isLoggable(XLoggerImpl.strToLevel("warning")) && this.accept(tag)) {
                this.logger.log(Level.WARNING, XLoggerImpl.buildMsg(throwable, warning), tag);
            }
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    @Override
    public void logN(@Nonnull String tag, @Nonnull String notice) {
        this.logN(tag, null, notice);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logN(@Nonnull String tag, @Nullable Throwable throwable, @Nonnull String notice) {
        this.rwLock.readLock().lock();
        try {
            if (this.logger.isLoggable(XLoggerImpl.strToLevel("notice")) && this.accept(tag)) {
                this.logger.log(Level.INFO, XLoggerImpl.buildMsg(throwable, notice), tag);
            }
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    @Override
    public void logD(@Nonnull String tag, @Nonnull String detail) {
        this.logD(tag, null, detail);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logD(@Nonnull String tag, @Nullable Throwable throwable, @Nonnull String detail) {
        this.rwLock.readLock().lock();
        try {
            if (this.logger.isLoggable(XLoggerImpl.strToLevel("detail")) && this.accept(tag)) {
                this.logger.log(Level.CONFIG, XLoggerImpl.buildMsg(throwable, detail), tag);
            }
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    @Override
    public boolean accept(@Nonnull String tag) {
        return this.tagRegex != null && this.tagRegex.matcher(tag).matches();
    }

    @Override
    @Nonnull
    public String getLevel() {
        return XLoggerImpl.levelToStr(this.logger.getLevel());
    }

    @Override
    public void setLevel(@Nonnull String level) {
        this.logger.setLevel(XLoggerImpl.strToLevel(level));
    }

    @Override
    public void addHandler(@Nonnull XLogger.Handler handler) {
        this.rwLock.writeLock().lock();
        try {
            this.handlers.add(handler);
            if (handler instanceof Handler) {
                this.logger.addHandler((Handler)((Object)handler));
            } else {
                this.logger.addHandler(new HandlerWrapper(handler));
            }
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    @Override
    @Nonnull
    public XLogger.Handler[] getHandlers() {
        this.rwLock.readLock().lock();
        try {
            XLogger.Handler[] handlerArray = this.handlers.toArray(new XLogger.Handler[0]);
            return handlerArray;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    public static class XFileHandler
    extends FileHandler
    implements XLogger.Handler {
        public XFileHandler() throws IOException {
            super(XTools.cfgDef(XLoggerImpl.CFG_FILE, XLoggerImpl.CFG_FILE_DEFAULT).trim(), Boolean.parseBoolean(XTools.cfgDef(XLoggerImpl.CFG_FILE_APPEND, XLoggerImpl.CFG_FILE_APPEND_DEFAULT).trim()));
            this.setLevel(XLoggerImpl.strToLevel(XTools.cfgDef(XLoggerImpl.CFG_FILE_LEVEL, "detail").trim()));
            this.setFormatter((Formatter)XConfigTools.supply(XTools.cfgDef(XLoggerImpl.CFG_FORMATTER, CFG_FORMATTER_DEFAULT).trim()));
        }

        @Override
        public void record(@Nonnull String level, @Nonnull String tag, @Nonnull String msg) {
            LogRecord logRecord = new LogRecord(XLoggerImpl.strToLevel(level), msg);
            logRecord.setParameters(new Object[]{tag});
            this.publish(logRecord);
        }
    }

    public static class XConsoleHandler
    extends ConsoleHandler
    implements XLogger.Handler {
        public XConsoleHandler() {
            this.setLevel(XLoggerImpl.strToLevel(XTools.cfgDef(XLoggerImpl.CFG_CONSOLE_LEVEL, "detail").trim()));
            this.setFormatter((Formatter)XConfigTools.supply(XTools.cfgDef(XLoggerImpl.CFG_FORMATTER, CFG_FORMATTER_DEFAULT).trim()));
        }

        @Override
        public void record(@Nonnull String level, @Nonnull String tag, @Nonnull String msg) {
            LogRecord logRecord = new LogRecord(XLoggerImpl.strToLevel(level), msg);
            logRecord.setParameters(new Object[]{tag});
            this.publish(logRecord);
        }
    }

    public static class XLogFormatter
    extends Formatter {
        private static final String TIME_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS";

        private char levelChar(@Nullable Level level) {
            if (Level.SEVERE.equals(level)) {
                return 'E';
            }
            if (Level.WARNING.equals(level)) {
                return 'W';
            }
            if (Level.INFO.equals(level)) {
                return 'N';
            }
            return 'D';
        }

        @Override
        public String format(LogRecord record) {
            String time = XTools.dateFormat(TIME_FORMAT, new Date(record.getMillis()));
            String tag = record.getParameters() == null || record.getParameters()[0] == null ? "xlog" : String.valueOf(record.getParameters()[0]);
            return String.format("%s|%s|%s| %s | %s\n", time, Character.valueOf(this.levelChar(record.getLevel())), Thread.currentThread().getName(), tag, record.getMessage());
        }
    }

    private static class HandlerWrapper
    extends Handler {
        @Nonnull
        private final XLogger.Handler handler;

        public HandlerWrapper(@Nonnull XLogger.Handler handler) {
            this.handler = handler;
        }

        @Override
        public void publish(LogRecord record) {
            this.handler.record(XLoggerImpl.levelToStr(record.getLevel()), (String)record.getParameters()[0], record.getMessage());
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() throws SecurityException {
        }
    }
}

