/*
 * Decompiled with CFR 0.152.
 */
package me.xuxiaoxiao.xtools.common.time;

import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;

class XLunarDb {
    public static final String MIN_DATE = "1901-02-19";
    public static final String MAX_DATE = "2101-01-29";
    public static final int MIN_YEAR = 1901;
    public static final int MAX_YEAR = 2101;
    public static final TLLunar TL_LUNAR = new TLLunar();
    public static final String[] LUNAR_MONTH = new String[]{"\u6b63", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d", "\u5341", "\u51ac", "\u814a"};
    public static final String[] LUNAR_DAY = new String[]{"\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d"};
    public static final String LUNAR_PATTERN = "((19|20|21)\\d{2})\u5e74(\u95f0)?([\u6b63\u4e8c\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d\u5341\u51ac\u814a])\u6708(([\u521d\u5341\u5eff])([\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d])|\u521d\u5341|\u4e8c\u5341|\u4e09\u5341)";
    public static final int[] LUNAR_INFO = new int[]{19168, 42352, 21717, 53856, 55632, 91476, 22176, 39632, 21970, 19168, 42422, 42192, 53840, 119381, 46400, 54944, 44450, 38320, 84343, 18800, 42160, 46261, 27216, 27968, 109396, 11104, 38256, 21234, 18800, 25958, 54432, 59984, 28309, 23248, 11104, 100067, 37600, 116951, 51536, 54432, 120998, 46416, 22176, 107956, 9680, 37584, 53938, 43344, 46423, 27808, 46416, 86869, 19872, 42416, 83315, 21168, 43432, 59728, 27296, 44710, 43856, 19296, 43748, 42352, 21088, 62051, 55632, 23383, 22176, 38608, 19925, 19152, 42192, 54484, 53840, 54616, 46400, 46752, 103846, 38320, 18864, 43380, 42160, 45690, 27216, 27968, 44870, 43872, 38256, 19189, 18800, 25776, 29859, 59984, 27480, 21952, 43872, 38613, 37600, 51552, 55636, 54432, 55888, 30034, 22176, 43959, 9680, 37584, 51893, 43344, 46240, 47780, 44368, 21977, 19360, 42416, 86390, 21168, 43312, 31060, 27296, 44368, 23378, 19296, 42726, 42208, 53856, 60005, 54576, 23200, 30371, 38608, 19195, 19152, 42192, 118966, 53840, 54560, 56645, 46496, 22224, 21938, 18864, 42359, 42160, 43600, 111189, 27936, 44448, 84835, 37744, 18936, 18800, 25776, 92326, 59984, 27424, 108228, 43744, 41696, 53987, 51552, 54615, 54432, 55888, 23893, 22176, 42704, 21972, 21200, 43448, 43344, 46240, 46758, 44368, 21920, 43940, 42416, 21168, 45683, 26928, 29495, 27296, 44368, 84821, 19296, 42352, 21732, 53600, 59752, 54560, 55968, 92838, 22224, 19168, 43476, 41680, 53584, 62034, 54560};

    XLunarDb() {
    }

    public static int lunarMonthDays(int lunarYear, int lunarMonth, boolean lunarLeap) {
        if (lunarLeap) {
            return (LUNAR_INFO[lunarYear - 1901] & 0x10000) == 0 ? 29 : 30;
        }
        return (LUNAR_INFO[lunarYear - 1901] & 1 << 16 - lunarMonth) == 0 ? 29 : 30;
    }

    public static int lunarYearDays(int lunarYear) {
        if ((LUNAR_INFO[lunarYear - 1901] & 0xF) == 0) {
            return 348 + Integer.bitCount(LUNAR_INFO[lunarYear - 1901] & 0xFFF0);
        }
        return 377 + Integer.bitCount(LUNAR_INFO[lunarYear - 1901] & 0x1FFF0);
    }

    public static void checkLunarDate(int lunarYear, int lunarMonth, int lunarDay, boolean lunarLeap) {
        if (lunarYear < 1901 || 2101 <= lunarYear) {
            throw new RuntimeException("\u975e\u6cd5\u519c\u5386\u5e74\u4efd\uff01");
        }
        if (lunarMonth < 1 || 12 < lunarMonth) {
            throw new RuntimeException("\u975e\u6cd5\u519c\u5386\u6708\u4efd\uff01");
        }
        if (lunarLeap && (LUNAR_INFO[lunarYear - 1901] & 0xF) != lunarMonth) {
            throw new RuntimeException(String.format("\u519c\u5386%d\u5e74%d\u6708\u4e0d\u662f\u95f0\u6708", lunarYear, lunarMonth));
        }
        if (lunarDay < 1 || lunarDay > XLunarDb.lunarMonthDays(lunarYear, lunarMonth, lunarLeap)) {
            throw new RuntimeException("\u975e\u6cd5\u519c\u5386\u5929\u6570\uff01");
        }
    }

    public static class TLLunar
    extends ThreadLocal<SimpleDateFormat> {
        @Override
        protected SimpleDateFormat initialValue() {
            SimpleDateFormat sdfLunar = new SimpleDateFormat("yyyy-MM-dd", Locale.CHINA);
            sdfLunar.setTimeZone(TimeZone.getTimeZone("Asia/Shanghai"));
            return sdfLunar;
        }
    }
}

