/*
 * Decompiled with CFR 0.152.
 */
package me.yanaga.opes;

import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import java.io.Serializable;
import java.util.Formattable;
import java.util.Formatter;
import java.util.Objects;

public class Cep
implements Serializable,
Formattable,
Comparable<Cep> {
    private static final long serialVersionUID = 1L;
    private final String value;

    private Cep(String value) {
        this.value = value;
    }

    public static Cep of(String value) {
        Preconditions.checkNotNull((Object)value);
        String digits = value.replaceAll("\\D", "");
        Preconditions.checkArgument((boolean)digits.matches("\\d{8}"));
        return new Cep(digits);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Cep) {
            Cep other = (Cep)obj;
            return Objects.equals(this.value, other.value);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return this.value;
    }

    @Override
    public void formatTo(Formatter formatter, int flags, int width, int precision) {
        boolean alternate;
        StringBuilder sb = new StringBuilder();
        boolean bl = alternate = (flags & 4) == 4;
        if (alternate) {
            sb.append(this.value);
        } else {
            sb.append(this.value.substring(0, 5));
            sb.append("-");
            sb.append(this.value.substring(5));
        }
        int length = sb.length();
        if (length < width) {
            for (int i = 0; i < width - length; ++i) {
                boolean leftJustified;
                if (alternate) {
                    sb.insert(0, '0');
                    continue;
                }
                boolean bl2 = leftJustified = (flags & 1) == 1;
                if (leftJustified) {
                    sb.append(' ');
                    continue;
                }
                sb.insert(0, ' ');
            }
        }
        formatter.format(sb.toString(), new Object[0]);
    }

    @Override
    public int compareTo(Cep o) {
        return ComparisonChain.start().compare((Comparable)((Object)this.value), (Comparable)((Object)o.value)).result();
    }
}

