/*
 * Decompiled with CFR 0.152.
 */
package me.yanaga.opes;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import java.io.Serializable;
import java.util.Formattable;
import java.util.Formatter;
import me.yanaga.opes.Cpf;

public class Cns
implements Serializable,
Formattable,
Comparable<Cns> {
    private static final long serialVersionUID = 1L;
    private final String value;

    private Cns(String value) {
        this.value = value;
    }

    public static Cns of(String value) {
        Preconditions.checkNotNull((Object)value);
        String digits = value.replaceAll("\\D", "");
        Preconditions.checkArgument((boolean)digits.matches("\\d{15}"));
        Preconditions.checkArgument((!digits.matches("(\\d)\\1+") ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)Cns.isValid(digits));
        return new Cns(digits);
    }

    static boolean isValid(String s) {
        if (s.matches("[1-2]\\d{10}00[0-1]\\d") || s.matches("[7-9]\\d{14}")) {
            return Cns.somaPonderada(s) % 11 == 0;
        }
        return false;
    }

    static int somaPonderada(String s) {
        Preconditions.checkArgument((s.length() <= 15 ? 1 : 0) != 0);
        char[] cs = s.toCharArray();
        int soma = 0;
        for (int i = 0; i < cs.length; ++i) {
            soma += Character.digit(cs[i], 10) * (15 - i);
        }
        return soma;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Cpf) {
            Cns other = (Cns)obj;
            return Objects.equal((Object)this.value, (Object)other.value);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.value});
    }

    public String toString() {
        return this.value;
    }

    @Override
    public void formatTo(Formatter formatter, int flags, int width, int precision) {
        boolean alternate;
        StringBuilder sb = new StringBuilder();
        boolean bl = alternate = (flags & 4) == 4;
        if (alternate) {
            sb.append(this.value);
        } else {
            sb.append(String.format("%s %s %s %s", this.value.substring(0, 3), this.value.substring(3, 7), this.value.substring(7, 11), this.value.substring(11)));
        }
        int length = sb.length();
        if (length < width) {
            for (int i = 0; i < width - length; ++i) {
                boolean leftJustified;
                if (alternate) {
                    sb.insert(0, '0');
                    continue;
                }
                boolean bl2 = leftJustified = (flags & 1) == 1;
                if (leftJustified) {
                    sb.append(' ');
                    continue;
                }
                sb.insert(0, ' ');
            }
        }
        formatter.format(sb.toString(), new Object[0]);
    }

    @Override
    public int compareTo(Cns o) {
        return ComparisonChain.start().compare((Comparable)((Object)this.value), (Comparable)((Object)o.value)).result();
    }
}

