/*
 * Decompiled with CFR 0.152.
 */
package me.yanaga.opes;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Ordering;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Formattable;
import java.util.Formatter;
import java.util.Optional;
import me.yanaga.opes.Cnpj;
import me.yanaga.opes.Cpf;

public class CpfCnpj
implements Serializable,
Formattable,
Comparable<CpfCnpj> {
    private static final long serialVersionUID = 1L;
    private final Optional<Cpf> cpf;
    private final Optional<Cnpj> cnpj;

    private CpfCnpj(Cpf cpf) {
        this.cpf = Optional.of(cpf);
        this.cnpj = Optional.empty();
    }

    private CpfCnpj(Cnpj cnpj) {
        this.cpf = Optional.empty();
        this.cnpj = Optional.of(cnpj);
    }

    public static CpfCnpj of(String value) {
        Preconditions.checkNotNull((Object)value);
        String digits = value.replaceAll("\\D", "");
        if (digits.matches("\\d{11}")) {
            return new CpfCnpj(Cpf.of(digits));
        }
        if (digits.matches("\\d{14}")) {
            return new CpfCnpj(Cnpj.of(digits));
        }
        throw new IllegalArgumentException(String.format("CPF/CNPJ inv\u00e1lido: %s.", value));
    }

    public boolean equals(Object obj) {
        if (obj instanceof CpfCnpj) {
            CpfCnpj other = (CpfCnpj)obj;
            return Objects.equal(this.cpf, other.cpf) && Objects.equal(this.cnpj, other.cnpj);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.cpf, this.cnpj});
    }

    public String toString() {
        return this.cpf.map(Cpf::toString).orElseGet(() -> this.cnpj.map(Cnpj::toString).get());
    }

    @Override
    public void formatTo(Formatter formatter, int flags, int width, int precision) {
        this.cpf.ifPresent(cpf -> cpf.formatTo(formatter, flags, width, precision));
        this.cnpj.ifPresent(cnpj -> cnpj.formatTo(formatter, flags, width, precision));
    }

    @Override
    public int compareTo(CpfCnpj o) {
        return ComparisonChain.start().compare(this.cpf.orElse(null), o.cpf.orElse(null), (Comparator)Ordering.natural().nullsLast()).compare(this.cnpj.orElse(null), o.cnpj.orElse(null), (Comparator)Ordering.natural().nullsLast()).result();
    }

    public boolean isCpf() {
        return this.cpf.isPresent();
    }

    public boolean isCnpj() {
        return this.cnpj.isPresent();
    }

    public Optional<Cpf> getCpf() {
        return this.cpf;
    }

    public Optional<Cnpj> getCnpj() {
        return this.cnpj;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        throw new InvalidObjectException("Proxy required");
    }

    private Object writeReplace() {
        return new SerializationProxy(this.toString());
    }

    private static class SerializationProxy
    implements Serializable {
        private final String value;

        private SerializationProxy(String value) {
            this.value = value;
        }

        private Object readResolve() {
            return CpfCnpj.of(this.value);
        }
    }
}

