/*
 * Decompiled with CFR 0.152.
 */
package me.yanaga.opes;

import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import java.io.Serializable;
import java.util.Formattable;
import java.util.Formatter;
import java.util.Objects;

public class Cpf
implements Serializable,
Formattable,
Comparable<Cpf> {
    private static final long serialVersionUID = 1L;
    private final String value;

    private Cpf(String value) {
        this.value = value;
    }

    public static Cpf of(String value) {
        Preconditions.checkNotNull((Object)value);
        String digits = value.replaceAll("\\D", "");
        Preconditions.checkArgument((boolean)digits.matches("\\d{11}"));
        Preconditions.checkArgument((!digits.matches("(\\d)\\1+") ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)Cpf.isValid(digits.substring(0, 10)));
        Preconditions.checkArgument((boolean)Cpf.isValid(digits));
        return new Cpf(digits);
    }

    static boolean isValid(String digits) {
        if (Long.parseLong(digits) % 10L == 0L) {
            return Cpf.somaPonderada(digits) % 11 < 2;
        }
        return Cpf.somaPonderada(digits) % 11 == 0;
    }

    static int somaPonderada(String digits) {
        char[] cs = digits.toCharArray();
        int soma = 0;
        for (int i = 0; i < cs.length; ++i) {
            soma += Character.digit(cs[i], 10) * (cs.length - i);
        }
        return soma;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Cpf) {
            Cpf other = (Cpf)obj;
            return Objects.equals(this.value, other.value);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return this.value;
    }

    @Override
    public void formatTo(Formatter formatter, int flags, int width, int precision) {
        boolean alternate;
        StringBuilder sb = new StringBuilder();
        boolean bl = alternate = (flags & 4) == 4;
        if (alternate) {
            sb.append(this.value);
        } else {
            sb.append(String.format("%s.%s.%s-%s", this.value.substring(0, 3), this.value.substring(3, 6), this.value.substring(6, 9), this.value.substring(9)));
        }
        int length = sb.length();
        if (length < width) {
            for (int i = 0; i < width - length; ++i) {
                boolean leftJustified;
                if (alternate) {
                    sb.insert(0, '0');
                    continue;
                }
                boolean bl2 = leftJustified = (flags & 1) == 1;
                if (leftJustified) {
                    sb.append(' ');
                    continue;
                }
                sb.insert(0, ' ');
            }
        }
        formatter.format(sb.toString(), new Object[0]);
    }

    @Override
    public int compareTo(Cpf o) {
        return ComparisonChain.start().compare((Comparable)((Object)this.value), (Comparable)((Object)o.value)).result();
    }
}

