/*
 * Decompiled with CFR 0.152.
 */
package me.yanaga.opes;

import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import java.io.Serializable;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Email
implements Serializable,
Comparable<Email> {
    private static final long serialVersionUID = 1L;
    private static final String ATOM = "[a-z0-9!#$%&'*+/=?^_`{|}~-]";
    private static final String DOMAIN = "([a-z0-9!#$%&'*+/=?^_`{|}~-]+(\\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*";
    private static final String IP_DOMAIN = "\\[[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\]";
    private static final Pattern pattern = Pattern.compile("^[a-z0-9!#$%&'*+/=?^_`{|}~-]+(\\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*@([a-z0-9!#$%&'*+/=?^_`{|}~-]+(\\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*|\\[[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\])$", 2);
    private final String value;

    private Email(String value) {
        this.value = value;
    }

    public static Email of(String value) {
        Preconditions.checkNotNull((Object)value);
        Matcher m = pattern.matcher(value);
        Preconditions.checkArgument((boolean)m.matches());
        return new Email(value);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Email) {
            Email other = (Email)obj;
            return Objects.equals(this.value, other.value);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return this.value;
    }

    @Override
    public int compareTo(Email o) {
        return ComparisonChain.start().compare((Comparable)((Object)this.value), (Comparable)((Object)o.value)).result();
    }
}

