/*
 * Decompiled with CFR 0.152.
 */
package me.yarhoslav.ymactors.core.actors;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import me.yarhoslav.ymactors.core.actors.IActorContext;
import me.yarhoslav.ymactors.core.actors.IActorRef;
import me.yarhoslav.ymactors.core.actors.Worker;
import me.yarhoslav.ymactors.core.actors.minions.IMinions;
import me.yarhoslav.ymactors.core.actors.minions.SimpleMinions;
import me.yarhoslav.ymactors.core.messages.DeadMsg;
import me.yarhoslav.ymactors.core.messages.HighPriorityEnvelope;
import me.yarhoslav.ymactors.core.messages.IEnvelope;
import me.yarhoslav.ymactors.core.messages.NormalPriorityEnvelope;
import me.yarhoslav.ymactors.core.messages.PoisonPill;
import me.yarhoslav.ymactors.core.minds.IActorMind;
import me.yarhoslav.ymactors.core.minds.InternalActorMind;
import me.yarhoslav.ymactors.core.minds.SimpleExternalActorMind;
import me.yarhoslav.ymactors.core.minds.SupervisorMind;
import me.yarhoslav.ymactors.core.services.BroadcastService;
import me.yarhoslav.ymactors.core.system.ISystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SimpleActor
implements IActorRef,
IActorContext {
    public static final int ALIVE = 0;
    public static final int STARTING = 1;
    public static final int RUNNING = 2;
    public static final int CLOSING = 3;
    public static final int DYING = 5;
    public static final int DEAD = 6;
    public static final int ERROR = -1;
    private final Logger logger = LoggerFactory.getLogger(SimpleActor.class);
    private final String name;
    private final String addr;
    private final String id;
    private final IActorRef parent;
    private final IMinions minions;
    private final ISystem system;
    private final IActorMind internalMind;
    private final SimpleExternalActorMind externalMind;
    private final IActorMind supervisorMind;
    private IEnvelope actualEnvelope;
    private final AtomicInteger internalStatus;
    private final AtomicBoolean hasQuantum;
    private final Worker worker;
    private final int dispatcher;

    public <E extends SimpleExternalActorMind> SimpleActor(String pName, String pAddr, IActorRef pParent, ISystem pSystem, E pExternalMind) throws IllegalArgumentException {
        this.name = pName;
        this.addr = pAddr;
        this.id = this.addr + "/" + this.name;
        this.parent = pParent;
        this.system = pSystem;
        this.internalMind = new InternalActorMind(this);
        this.supervisorMind = new SupervisorMind(this);
        this.externalMind = pExternalMind;
        this.minions = new SimpleMinions(this, this.system);
        this.internalStatus = new AtomicInteger(0);
        this.hasQuantum = new AtomicBoolean(false);
        this.worker = new Worker(this);
        this.dispatcher = this.system.getDispatcher();
    }

    @Override
    public void tell(Object pData, IActorRef pSender) {
        this.tell(new NormalPriorityEnvelope(pData, pSender));
    }

    @Override
    public void tell(IEnvelope pEnvelope) {
        int actualStatus = this.internalStatus.get();
        if (actualStatus == 2 || actualStatus == 3) {
            this.worker.newMessage(pEnvelope);
        }
    }

    public final void start() {
        this.internalStatus.set(1);
        try {
            this.externalMind.initialize(this);
            this.externalMind.postStart();
            this.internalStatus.set(2);
        }
        catch (Exception e) {
            this.logger.warn("An exception occurs starting actor {}.  Stoping Actor.", (Object)this.name, (Object)e);
            this.stop();
        }
    }

    public final void stop() {
        this.internalStatus.set(5);
        try {
            this.externalMind.beforeStop();
        }
        catch (Exception e) {
            this.logger.warn("An exception occurs stopping actor {}.  Excetion was ignored.", (Object)this.name, (Object)e);
        }
        finally {
            this.worker.stop();
            this.parent.tell(new HighPriorityEnvelope((Object)DeadMsg.INSTANCE, this));
            BroadcastService broadcast = new BroadcastService(this.minions.all());
            broadcast.send(new HighPriorityEnvelope((Object)PoisonPill.INSTANCE, this));
            this.minions.removeAll();
            this.internalStatus.set(6);
        }
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String address() {
        return this.addr;
    }

    @Override
    public IActorRef myself() {
        return this;
    }

    @Override
    public ISystem system() {
        return this.system;
    }

    @Override
    public IEnvelope envelope() {
        return this.actualEnvelope;
    }

    @Override
    public IActorRef parent() {
        return this.parent;
    }

    @Override
    public IMinions minions() {
        return this.minions;
    }

    @Override
    public int status() {
        return this.internalStatus.get();
    }

    @Override
    public <E extends SimpleExternalActorMind> IActorRef createMinion(E pMinionMind, String pName) {
        return this.minions.add(pMinionMind, pName);
    }

    @Override
    public int dispatcher() {
        return this.dispatcher;
    }

    private void internalErrorHandler(Exception pException) {
        this.internalStatus.set(-1);
        this.externalMind.handleException(pException);
        this.stop();
    }

    @Override
    public void think(IEnvelope pEnvelope) {
        this.actualEnvelope = pEnvelope;
        if (this.actualEnvelope != null) {
            try {
                this.internalMind.process();
                this.supervisorMind.process();
                this.externalMind.process();
            }
            catch (Exception e) {
                this.logger.warn("An exception occurs processing message {}.  Excetion was ignored.", (Object)this.name, (Object)e);
                this.internalErrorHandler(e);
            }
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SimpleActor other = (SimpleActor)obj;
        return Objects.equals(this.id, other.id);
    }

    public int hashCode() {
        int hash = 5;
        hash = 67 * hash + Objects.hashCode(this.id);
        return hash;
    }
}

