/*
 * Decompiled with CFR 0.152.
 */
package me.yarhoslav.ymactors.core.actors;

import java.util.Queue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import me.yarhoslav.ymactors.core.actors.IActorContext;
import me.yarhoslav.ymactors.core.actors.IWorker;
import me.yarhoslav.ymactors.core.messages.IEnvelope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Worker
implements IWorker {
    private final Logger logger = LoggerFactory.getLogger(Worker.class);
    public static final int IDLE = 0;
    public static final int WAITING = 1;
    public static final int RUNNING = 2;
    public static final int STOPPED = 3;
    public static final int DEAD = 4;
    public static final int ERROR = -1;
    private final Queue<IEnvelope> mailbox = new PriorityBlockingQueue<IEnvelope>();
    private final AtomicInteger status = new AtomicInteger(0);
    private final IActorContext context;

    public Worker(IActorContext pContext) {
        this.context = pContext;
    }

    private void setStatusWaiting() {
        this.status.set(1);
        this.requestQuantum();
    }

    private void setStatusStopping() {
        this.status.set(3);
        if (!this.mailbox.isEmpty()) {
            this.setStatusWaiting();
        } else {
            this.setStatusIdle();
        }
    }

    private void setStatusIdle() {
        this.status.set(0);
    }

    private void setStatusRunnig() {
        this.status.set(2);
    }

    @Override
    public void newMessage(IEnvelope pEnvelope) {
        this.mailbox.offer(pEnvelope);
        if (this.status.get() == 0) {
            this.setStatusWaiting();
        }
    }

    private void requestQuantum() {
        boolean quantumAccepted = this.context.system().requestQuantum(this.context.dispatcher(), this);
        if (!quantumAccepted) {
            this.internalErrorHandler(new IllegalStateException(String.format("Quantum executor system %s has denied allocation of a new task for Actor %s", this.context.system().name(), this.context.id())));
        }
    }

    private void internalErrorHandler(Exception e) {
        this.logger.warn("Exception was ignored:", (Throwable)e);
    }

    @Override
    public void stop() {
        this.mailbox.clear();
        this.status.set(4);
    }

    @Override
    public void run() {
        this.setStatusRunnig();
        IEnvelope actualEnvelope = this.mailbox.poll();
        this.context.think(actualEnvelope);
        this.setStatusStopping();
    }
}

