/*
 * Decompiled with CFR 0.152.
 */
package me.yarhoslav.ymactors.core.actors.minions;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import me.yarhoslav.ymactors.core.actors.IActorRef;
import me.yarhoslav.ymactors.core.actors.SimpleActor;
import me.yarhoslav.ymactors.core.actors.minions.IMinions;
import me.yarhoslav.ymactors.core.minds.SimpleExternalActorMind;
import me.yarhoslav.ymactors.core.system.ISystem;

public final class SimpleMinions
implements IMinions {
    private final Map<String, SimpleActor> minions = new ConcurrentHashMap<String, SimpleActor>();
    private final IActorRef parent;
    private final ISystem system;

    public SimpleMinions(IActorRef pParent, ISystem pSystem) {
        this.parent = pParent;
        this.system = pSystem;
    }

    @Override
    public <E extends SimpleExternalActorMind> IActorRef add(E pMinionMind, String pName) throws IllegalArgumentException {
        SimpleActor tmpActor = new SimpleActor(pName, this.parent.id(), this.parent, this.system, pMinionMind);
        this.minions.put(tmpActor.name(), tmpActor);
        tmpActor.start();
        return tmpActor;
    }

    @Override
    public IActorRef find(String pName) throws IllegalArgumentException {
        if (!this.minions.containsKey(pName)) {
            throw new IllegalArgumentException(String.format("Actor with name:%s doesn't exists in Parent %s", pName, this.parent.id()));
        }
        return this.minions.get(pName);
    }

    @Override
    public SimpleActor summon(String pName) throws IllegalArgumentException {
        if (!this.minions.containsKey(pName)) {
            throw new IllegalArgumentException(String.format("Actor Id:%s doesn't exists in Parent %s", pName, this.parent.name()));
        }
        return this.minions.get(pName);
    }

    @Override
    public IActorRef remove(IActorRef pMinion) throws IllegalArgumentException {
        if (!this.minions.containsKey(pMinion.name())) {
            throw new IllegalArgumentException(String.format("Actor Id:%s doesn't exists in Parent %s", pMinion.name(), this.parent.name()));
        }
        return this.minions.remove(pMinion.name());
    }

    @Override
    public Iterator<SimpleActor> all() {
        return this.minions.values().iterator();
    }

    @Override
    public void removeAll() {
        this.minions.clear();
    }

    @Override
    public int count() {
        return this.minions.size();
    }
}

