/*
 * Decompiled with CFR 0.152.
 */
package me.yarhoslav.ymactors.core.services;

import java.util.Iterator;
import me.yarhoslav.ymactors.core.actors.IActorRef;
import me.yarhoslav.ymactors.core.messages.IEnvelope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BroadcastService {
    private final Logger logger = LoggerFactory.getLogger(BroadcastService.class);
    private final Iterator children;

    public BroadcastService(Iterator pChildren) {
        this.children = pChildren;
    }

    public BroadcastService send(Object pMsg, IActorRef pSender) {
        while (this.children.hasNext()) {
            IActorRef child = (IActorRef)this.children.next();
            child.tell(pMsg, pSender);
        }
        return this;
    }

    public BroadcastService send(IEnvelope pEnvelope) {
        while (this.children.hasNext()) {
            IActorRef child = (IActorRef)this.children.next();
            child.tell(pEnvelope);
        }
        return this;
    }
}

