/*
 * Decompiled with CFR 0.152.
 */
package me.yarhoslav.ymactors.core.system;

import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import me.yarhoslav.ymactors.core.actors.IActorRef;
import me.yarhoslav.ymactors.core.actors.NullActor;
import me.yarhoslav.ymactors.core.actors.SimpleActor;
import me.yarhoslav.ymactors.core.messages.IEnvelope;
import me.yarhoslav.ymactors.core.messages.PoisonPill;
import me.yarhoslav.ymactors.core.minds.DumbMind;
import me.yarhoslav.ymactors.core.minds.SimpleExternalActorMind;
import me.yarhoslav.ymactors.core.system.IQuantumExecutor;
import me.yarhoslav.ymactors.core.system.ISystem;
import me.yarhoslav.ymactors.core.system.QuantumExecutor;
import me.yarhoslav.ymactors.core.system.SchedulerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ActorSystem
implements ISystem {
    private final Logger logger = LoggerFactory.getLogger(ActorSystem.class);
    private final String name;
    private final IQuantumExecutor quantumsManager;
    private final ScheduledExecutorService scheduler;
    private final SimpleActor userSpace;

    public ActorSystem(String pName) {
        if (pName.length() <= 0) {
            throw new IllegalArgumentException("ActorSystem's name can't be blank");
        }
        this.name = pName;
        this.quantumsManager = new QuantumExecutor();
        this.scheduler = new ScheduledThreadPoolExecutor(1);
        this.userSpace = new SimpleActor("userspace", this.name + ":/", NullActor.INSTANCE, this, new DumbMind());
        this.userSpace.start();
    }

    @Override
    public boolean requestQuantum(int pDispatcher, Runnable pActor) {
        try {
            this.quantumsManager.submitTask(pDispatcher, pActor);
            return true;
        }
        catch (NullPointerException | RejectedExecutionException ex) {
            this.logger.warn("Failed submitting new task to Quantum Executor {}.  Exception ignored.", (Object)pActor, (Object)ex);
            return false;
        }
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public void shutdown() {
        this.userSpace.tell((Object)PoisonPill.INSTANCE, NullActor.INSTANCE);
        this.quantumsManager.shutdown();
    }

    @Override
    public <E extends SimpleExternalActorMind> IActorRef createActor(E pMinionMind, String pName) throws IllegalArgumentException {
        return this.userSpace.createMinion(pMinionMind, pName);
    }

    @Override
    public IActorRef findActor(String pId) throws IllegalArgumentException {
        String tmpId = pId;
        if (tmpId.startsWith(this.name + "://")) {
            tmpId = tmpId.substring(this.name.length() + ":/".length(), tmpId.length());
        }
        if (tmpId.startsWith("/userspace")) {
            tmpId = tmpId.substring("/userspace".length(), tmpId.length());
        }
        if (tmpId.startsWith("/")) {
            tmpId = tmpId.substring(1, tmpId.length());
            String[] path = tmpId.split("/");
            SimpleActor tmpActor = this.userSpace.minions().summon(path[0]);
            for (int i = 1; i < path.length; ++i) {
                tmpActor = tmpActor.minions().summon(path[i]);
            }
            return tmpActor;
        }
        throw new IllegalArgumentException(String.format("Invalid format for Actor's Id: %s", pId));
    }

    public String estadistica() {
        return "TODO...";
    }

    @Override
    public ScheduledFuture schedule(IActorRef pReceiver, IEnvelope pEnvelope, long delay, TimeUnit timeunit) {
        return this.scheduler.schedule(new SchedulerTask(pReceiver, pEnvelope), delay, timeunit);
    }

    @Override
    public ScheduledFuture scheduleAtFixedRate(IActorRef pReceiver, IEnvelope pEnvelope, long initialDelay, long period, TimeUnit timeunit) {
        return this.scheduler.scheduleAtFixedRate(new SchedulerTask(pReceiver, pEnvelope), initialDelay, period, timeunit);
    }

    @Override
    public ScheduledFuture scheduleWithFixedDelay(IActorRef pReceiver, IEnvelope pEnvelope, long initialDelay, long period, TimeUnit timeunit) {
        return this.scheduler.scheduleWithFixedDelay(new SchedulerTask(pReceiver, pEnvelope), initialDelay, period, timeunit);
    }

    @Override
    public int getDispatcher() {
        return this.quantumsManager.getDispatcher();
    }
}

