/*
 * Decompiled with CFR 0.152.
 */
package me.yarhoslav.ymactors.core.system;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import me.yarhoslav.ymactors.core.system.IQuantumExecutor;

public class QuantumExecutor
implements IQuantumExecutor {
    private final ExecutorService[] executors;
    private final AtomicInteger executorIndex;
    private final int coresAvailables = Runtime.getRuntime().availableProcessors();

    public QuantumExecutor() {
        this.executors = new ExecutorService[this.coresAvailables];
        this.initializeDispatchers();
        this.executorIndex = new AtomicInteger(0);
    }

    private void initializeDispatchers() {
        for (int i = 0; i < this.executors.length; ++i) {
            this.executors[i] = Executors.newSingleThreadExecutor();
        }
    }

    @Override
    public void submitTask(int pDispatcher, Runnable pTask) throws RejectedExecutionException, NullPointerException {
        this.executors[pDispatcher].submit(pTask);
    }

    @Override
    public int getDispatcher() {
        if (this.executorIndex.get() == Integer.MAX_VALUE) {
            this.executorIndex.set(0);
        } else {
            this.executorIndex.incrementAndGet();
        }
        return this.executorIndex.get() % this.coresAvailables;
    }

    @Override
    public void shutdown() {
        for (ExecutorService executor : this.executors) {
            executor.shutdown();
        }
    }
}

