package me.youm.boot.constant;

/**
 * Security 静态配置
 *
 * @author youta
 */
public class SecurityConstant {

    /**
     * 不需要认证的接口资源
     */
    public static final String HTTP_ACT_MATCHERS = "/webjars/springfox-swagger-ui/fonts/**,/swagger-resources,/swagger-resources/configuration/**,/webjars**,/swagger-ui.html,/webjars/springfox-swagger-ui/**,/v2/api-docs,/api/login,/api/captcha/create";

    /**
     * 不需要认证的静态资源
     */
    public static final String WEB_ACT_MATCHERS = "/favicon.ico";

    /**
     * 默认的登录接口
     */
    public static final String LOGIN_URL = "/api/login";

    /**
     * 登录接口方式
     */
    public static final String LOGIN_METHOD = "POST";

    /**
     * 默认的注销接口
     */
    public static final String LOGOUT_URL = "/api/logout";

    /**
     * 是否开启验证码
     */
    public static final Boolean IS_CAPTCHA_VERIFICATION = true;

    /**
     * Captcha 过期时间
     */
    public static final long CAPTCHA_EXPIRATION = 1000 * 60 * 5;

    /**
     * Token 过期时间
     */
    public static final long TOKEN_EXPIRATION = 1000 * 60 * 30;

}
