package me.youm.boot.web.domain;

/**
 * Ajax 响 应 处 理
 *
 * @author youta
 */
public class ResultController {

    /**
     * 成功操作
     * @return {@link Result}
     */
    public Result<?> success() {
        return Result.success();
    }

    /**
     * 成功操作
     * @param msg msg
     * @return {@link Result}
     */
    public Result<?> success(String msg) {
        return Result.success(msg);
    }

    /**
     * 成功操作
     * @param data data
     * @return {@link Result}
     */
    public Result<?> success(Object data) {
        return Result.success(data);
    }

    /**
     * 成功操作
     * @param msg msg
     * @param  data data
     * @return {@link Result}
     */
    public Result<?> success(String msg, Object data) {
        return Result.success(msg, data);
    }

    /**
     * 成功操作
     * @param code code
     * @param  message message
     * @param data data
     * @return {@link Result}
     */
    public Result<?> success(int code, String message, Object data) {
        return Result.success(code, message, data);
    }

    /**
     * 失败操作
     * @return {@link Result}
     */
    public Result<?> failure() {
        return Result.failure();
    }

    /**
     * 失败操作
     * @param msg msg
     * @return {@link Result}
     */
    public Result<?> failure(String msg) {
        return Result.failure(msg);
    }

    /**
     * 失败操作
     * @param msg msg
     * @param data data
     * @return {@link Result}
     */
    public Result<?> failure(String msg, Object data) {
        return Result.failure(msg, data);
    }

    /**
     * 失败操作
     * @param code code
     * @param msg msg
     * @param data data
     * @return {@link Result}
     */
    public Result<?> failure(int code, String msg, Object data) {
        return Result.failure(code, msg, data);
    }

    /**
     * 选择返回
     * @param b b
     * @return {@link Result}
     */
    public Result<?> auto(Boolean b) {
        return Result.auto(b);
    }

    /**
     * 选择返回
     * @param b b
     * @param success success
     * @param failure failure
     * @return {@link Result}
     */
    public Result<?> auto(Boolean b, String success, String failure) {
        return Result.auto(b, success, failure);
    }

}
