/*
 * Decompiled with CFR 0.152.
 */
package me.youm.boot.aop;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import me.youm.boot.aop.annotation.Excel;
import me.youm.boot.aop.enums.Model;
import me.youm.boot.tools.core.ExcelUtil;
import me.youm.boot.tools.core.ServletUtil;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class ExcelAspect {
    @Pointcut(value="@annotation(me.youm.boot.aop.annotation.Excel) || @within(me.youm.boot.aop.annotation.Excel)")
    public void dsPointCut() {
    }

    @Around(value="dsPointCut()")
    private Object around(ProceedingJoinPoint joinPoint) throws Throwable {
        Object data = null;
        Excel annotation = this.getAnnotation(joinPoint);
        Class<?> clazz = annotation.clazz();
        Model model = annotation.model();
        HttpServletResponse response = ServletUtil.getResponse();
        try {
            if (model.equals((Object)Model.READ)) {
                // empty if block
            }
            data = joinPoint.proceed();
            if (model.equals((Object)Model.WRITE)) {
                ExcelUtil.write(response, clazz, ExcelAspect.toList(data, clazz));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return data;
    }

    public Excel getAnnotation(ProceedingJoinPoint point) {
        MethodSignature signature = (MethodSignature)point.getSignature();
        Class<?> targetClass = point.getTarget().getClass();
        Excel targetExcel = targetClass.getAnnotation(Excel.class);
        if (targetExcel != null) {
            return targetExcel;
        }
        Method method = signature.getMethod();
        return method.getAnnotation(Excel.class);
    }

    public static <T> List<T> toList(Object obj, Class<T> clazz) {
        ArrayList<T> result = new ArrayList<T>();
        if (obj instanceof List) {
            for (Object o : (List)obj) {
                result.add(clazz.cast(o));
            }
            return result;
        }
        return null;
    }
}

