/*
 * Decompiled with CFR 0.152.
 */
package me.youm.boot.aop;

import java.lang.reflect.Method;
import javax.annotation.Resource;
import me.youm.boot.aop.annotation.Log;
import me.youm.boot.aop.enums.Action;
import me.youm.boot.context.BaseContext;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class LogAspect {
    @Resource
    private BaseContext context;

    @Pointcut(value="@annotation(me.youm.boot.aop.annotation.Log) || @within(me.youm.boot.aop.annotation.Log)")
    public void dsPointCut() {
    }

    @Around(value="dsPointCut()")
    private Object around(ProceedingJoinPoint joinPoint) throws Throwable {
        Object result = null;
        Log annotation = this.getAnnotation(joinPoint);
        String title = annotation.title();
        Action action = annotation.action();
        String describe = annotation.describe();
        try {
            result = joinPoint.proceed();
            this.context.record(title, describe, action, true, null, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.context.record(title, describe, action, false, null, null);
            throw e;
        }
        return result;
    }

    public Log getAnnotation(ProceedingJoinPoint point) {
        MethodSignature signature = (MethodSignature)point.getSignature();
        Class<?> targetClass = point.getTarget().getClass();
        Log targetLog = targetClass.getAnnotation(Log.class);
        if (targetLog != null) {
            return targetLog;
        }
        Method method = signature.getMethod();
        Log log = method.getAnnotation(Log.class);
        return log;
    }
}

