/*
 * Decompiled with CFR 0.152.
 */
package me.youm.boot.aop;

import com.alibaba.fastjson.JSON;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import me.youm.boot.aop.annotation.Repeat;
import me.youm.boot.context.UserContext;
import me.youm.boot.tools.core.ServletUtil;
import me.youm.boot.web.domain.Result;
import me.youm.boot.web.domain.ResultCode;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;

@Aspect
@Component
public class RepeatAspect
implements HandlerInterceptor {
    @Resource
    private RedisTemplate<String, Map<String, Object>> redisTemplate;
    @Resource
    private UserContext userContext;
    public final String REPEAT_PARAMS = "repeatParams";
    public final String REPEAT_TIME = "repeatTime";
    public final String SESSION_REPEAT_KEY = "repeatData";
    private int intervalTime = 10;

    @Pointcut(value="@annotation(me.youm.boot.aop.annotation.Repeat) || @within(me.youm.boot.aop.annotation.Repeat)")
    public void dsPointCut() {
    }

    public void setIntervalTime(int intervalTime) {
        this.intervalTime = intervalTime;
    }

    @Around(value="dsPointCut()")
    private Object around(ProceedingJoinPoint joinPoint) throws Throwable {
        Object data = null;
        Repeat annotation = this.getAnnotation(joinPoint);
        HttpServletRequest request = ServletUtil.getRequest();
        try {
            if (annotation != null && this.isRepeatSubmit(request)) {
                return Result.failure(ResultCode.REPEAT_SUBMIT);
            }
            data = joinPoint.proceed();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return data;
    }

    public boolean isRepeatSubmit(HttpServletRequest request) {
        String parameters = JSON.toJSONString((Object)request.getParameterMap());
        HashMap<String, Object> nowDataMap = new HashMap<String, Object>();
        nowDataMap.put("repeatParams", parameters);
        nowDataMap.put("repeatTime", System.currentTimeMillis());
        String url = request.getRequestURI();
        String userId = this.userContext.getUserId();
        String key = url + ":" + userId;
        Map preDataMap = (Map)this.redisTemplate.opsForValue().get((Object)key);
        if (preDataMap != null && this.compareParams(nowDataMap, preDataMap) && this.compareTime(nowDataMap, preDataMap)) {
            return true;
        }
        this.redisTemplate.opsForValue().set((Object)key, nowDataMap, 20L, TimeUnit.SECONDS);
        return false;
    }

    private boolean compareParams(Map<String, Object> nowMap, Map<String, Object> preMap) {
        String nowParams = (String)nowMap.get("repeatParams");
        String preParams = (String)preMap.get("repeatParams");
        return nowParams.equals(preParams);
    }

    private boolean compareTime(Map<String, Object> nowMap, Map<String, Object> preMap) {
        long time2;
        long time1 = (Long)nowMap.get("repeatTime");
        return time1 - (time2 = ((Long)preMap.get("repeatTime")).longValue()) < (long)this.intervalTime * 1000L;
    }

    public Repeat getAnnotation(ProceedingJoinPoint point) {
        MethodSignature signature = (MethodSignature)point.getSignature();
        Class<?> targetClass = point.getTarget().getClass();
        Repeat targetRepeat = targetClass.getAnnotation(Repeat.class);
        if (targetRepeat != null) {
            return targetRepeat;
        }
        Method method = signature.getMethod();
        return method.getAnnotation(Repeat.class);
    }
}

