/*
 * Decompiled with CFR 0.152.
 */
package me.youm.boot.configure;

import javax.annotation.Resource;
import javax.servlet.Filter;
import me.youm.boot.secure.captcha.SecureCaptchaSupport;
import me.youm.boot.secure.process.SecureLoginFailureHandler;
import me.youm.boot.secure.process.SecureLoginSuccessHandler;
import me.youm.boot.secure.process.SecureLogoutSuccessHandler;
import me.youm.boot.secure.process.SecureNoAuthenticationHandler;
import me.youm.boot.secure.process.SecureNoPermissionHandler;
import me.youm.boot.secure.uutoken.SecureUserTokenSupport;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.annotation.web.configurers.FormLoginConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;

@Configuration
@EnableWebSecurity
@EnableGlobalMethodSecurity(prePostEnabled=true)
public class SecurityConfig
extends WebSecurityConfigurerAdapter {
    @Resource
    private SecureLoginSuccessHandler secureAuthenticationSuccessHandler;
    @Resource
    private SecureLoginFailureHandler secureAuthenticationFailureHandler;
    @Resource
    private SecureLogoutSuccessHandler secureLogoutSuccessHandler;
    @Resource
    private SecureNoPermissionHandler secureAuthAccessDeniedHandler;
    @Resource
    private SecureNoAuthenticationHandler secureAuthenticationEntryPointHandler;

    @Bean
    public BCryptPasswordEncoder bCryptPasswordEncoder() {
        return new BCryptPasswordEncoder();
    }

    public void configure(WebSecurity web) {
        web.ignoring().antMatchers("/favicon.ico".split(","));
    }

    protected void configure(HttpSecurity http) throws Exception {
        ((HttpSecurity)((HttpSecurity)((HttpSecurity)((FormLoginConfigurer)((FormLoginConfigurer)((FormLoginConfigurer)((HttpSecurity)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().antMatchers("/webjars/springfox-swagger-ui/fonts/**,/swagger-resources,/swagger-resources/configuration/**,/webjars**,/swagger-ui.html,/webjars/springfox-swagger-ui/**,/v2/api-docs,/api/login,/api/captcha/create".split(","))).permitAll().anyRequest()).authenticated().and()).httpBasic().authenticationEntryPoint((AuthenticationEntryPoint)this.secureAuthenticationEntryPointHandler).and()).formLogin().loginProcessingUrl("/api/login")).successHandler((AuthenticationSuccessHandler)this.secureAuthenticationSuccessHandler)).failureHandler((AuthenticationFailureHandler)this.secureAuthenticationFailureHandler)).and()).logout().logoutUrl("/api/logout").logoutSuccessHandler((LogoutSuccessHandler)this.secureLogoutSuccessHandler).and()).exceptionHandling().accessDeniedHandler((AccessDeniedHandler)this.secureAuthAccessDeniedHandler).and()).csrf().disable();
        http.headers().frameOptions().disable();
        http.sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS);
        http.addFilterBefore((Filter)new SecureUserTokenSupport(), UsernamePasswordAuthenticationFilter.class);
        http.addFilterBefore((Filter)new SecureCaptchaSupport(), UsernamePasswordAuthenticationFilter.class);
        http.headers().cacheControl();
        http.cors();
    }
}

