/*
 * Decompiled with CFR 0.152.
 */
package me.youm.boot.context;

import com.alibaba.fastjson.JSON;
import javax.annotation.Resource;
import me.youm.boot.aop.enums.Action;
import me.youm.boot.context.UserContext;
import me.youm.boot.context.domain.SysLog;
import me.youm.boot.context.service.ILogService;
import me.youm.boot.tools.core.ServletUtil;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class BaseContext {
    @Resource
    private ILogService sysLogService;
    @Resource
    private UserContext userContext;

    @Async
    public void record(String title, String describe, Action action, Boolean state, String result, String error) {
        SysLog sysLog = new SysLog();
        sysLog.setTitle(title);
        sysLog.setAction(action);
        sysLog.setDescribe(describe);
        sysLog.setType(ServletUtil.getMethod());
        sysLog.setUrl(ServletUtil.getRequestURI());
        sysLog.setBrowser(ServletUtil.getBrowser());
        sysLog.setCreateBy(this.userContext.getUserId());
        sysLog.setAddress(ServletUtil.getRemoteHost());
        sysLog.setOperator(this.userContext.getNickName());
        sysLog.setResult(JSON.toJSONString((Object)result));
        sysLog.setSystem(ServletUtil.getSystem());
        sysLog.setState(state);
        sysLog.setError(error);
        this.sysLogService.save(sysLog);
    }
}

