/*
 * Decompiled with CFR 0.152.
 */
package me.youm.boot.context;

import com.baomidou.dynamic.datasource.DynamicRoutingDataSource;
import com.baomidou.dynamic.datasource.creator.DataSourceCreator;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DataSourceProperty;
import com.baomidou.dynamic.datasource.toolkit.DynamicDataSourceContextHolder;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.sql.DataSource;
import me.youm.boot.context.domain.SysDataSource;
import me.youm.boot.context.param.SysDataSourceRequest;
import me.youm.boot.context.service.IDataSourceService;
import org.springframework.stereotype.Component;

@Component
public class DataContext {
    @Resource
    protected DataSource dataSource;
    @Resource
    protected DataSourceCreator dataSourceCreator;
    @Resource
    private IDataSourceService sysDataSourceService;

    public void createDataSource(String name, String username, String password, String url, String driver) {
        DynamicRoutingDataSource dynamicRoutingDataSource = (DynamicRoutingDataSource)this.dataSource;
        DataSourceProperty dsp = new DataSourceProperty();
        dsp.setPoolName(name);
        dsp.setUrl(url);
        dsp.setUsername(username);
        dsp.setPassword(password);
        dsp.setDriverClassName(driver);
        DataSource dataSource = this.dataSourceCreator.createDataSource(dsp);
        dynamicRoutingDataSource.addDataSource(name, dataSource);
    }

    public void changeDataSource(String name) {
        DynamicDataSourceContextHolder.push((String)name);
    }

    public void cleanDataSource(String name) {
        DynamicDataSourceContextHolder.poll();
    }

    public void updateDataSource(String name, String username, String password, String url, String driver) {
        this.removeDataSource(name);
        this.createDataSource(name, username, password, url, driver);
    }

    public void removeDataSource(String name) {
        DynamicRoutingDataSource dynamicRoutingDataSource = (DynamicRoutingDataSource)this.dataSource;
        dynamicRoutingDataSource.removeDataSource(name);
    }

    public Map<String, DataSource> getDataSources() {
        DynamicRoutingDataSource dynamicRoutingDataSource = (DynamicRoutingDataSource)this.dataSource;
        return dynamicRoutingDataSource.getCurrentDataSources();
    }

    public DataSource getDataSource(String name) {
        DynamicRoutingDataSource dynamicRoutingDataSource = (DynamicRoutingDataSource)this.dataSource;
        return dynamicRoutingDataSource.getDataSource(name);
    }

    @PostConstruct
    public void loadDataSource() {
        List<SysDataSource> sysDataSources = this.sysDataSourceService.list(new SysDataSourceRequest());
        sysDataSources.forEach(sysDataSource -> this.createDataSource(sysDataSource.getName(), sysDataSource.getUsername(), sysDataSource.getPassword(), sysDataSource.getUrl(), sysDataSource.getDriver()));
    }
}

