/*
 * Decompiled with CFR 0.152.
 */
package me.youm.boot.secure.captcha;

import com.wf.captcha.SpecCaptcha;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import me.youm.boot.secure.captcha.SecureCaptcha;
import me.youm.boot.web.exception.auth.captcha.CaptchaExpiredException;
import me.youm.boot.web.exception.auth.captcha.CaptchaValidationException;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class SecureCaptchaService {
    @Resource
    private RedisTemplate<String, String> redisTemplate;

    public SecureCaptcha createCaptcha() {
        SpecCaptcha captcha = new SpecCaptcha(142, 38);
        String key = UUID.randomUUID().toString();
        String code = captcha.text().toLowerCase();
        this.redisTemplate.opsForValue().set((Object)("CAPTCHA-" + key), (Object)code, 300000L, TimeUnit.SECONDS);
        return new SecureCaptcha(key, code, captcha.toBase64());
    }

    public void verifyCaptcha(String key, String code) {
        String redisCode = this.taskCaptcha(key);
        if (redisCode == null) {
            throw new CaptchaExpiredException("captcha expired");
        }
        if (!redisCode.equals(code)) {
            throw new CaptchaValidationException("captcha invalid");
        }
    }

    public String taskCaptcha(String key) {
        return (String)this.redisTemplate.opsForValue().get((Object)("CAPTCHA-" + key));
    }

    public void destroyCaptcha(String key) {
        this.redisTemplate.delete((Object)("CAPTCHA-" + key));
    }
}

