/*
 * Decompiled with CFR 0.152.
 */
package me.youm.boot.secure.captcha;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import me.youm.boot.constant.SecurityConstant;
import me.youm.boot.context.BeanContext;
import me.youm.boot.secure.captcha.SecureCaptchaService;
import me.youm.boot.tools.core.ServletUtil;
import me.youm.boot.web.domain.Result;
import me.youm.boot.web.domain.ResultCode;
import me.youm.boot.web.exception.auth.captcha.CaptchaExpiredException;
import me.youm.boot.web.exception.auth.captcha.CaptchaValidationException;
import org.apache.logging.log4j.util.Strings;
import org.springframework.web.filter.OncePerRequestFilter;

public class SecureCaptchaSupport
extends OncePerRequestFilter {
    public static final String CAPTCHA_KEY = "captchaKey";
    public static final String CAPTCHA_CODE = "captchaCode";
    private final SecureCaptchaService customCaptchaService = BeanContext.getBean("secureCaptchaService", SecureCaptchaService.class);

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws ServletException, IOException {
        String captchaKey = ServletUtil.getParameter(CAPTCHA_KEY);
        String captchaCode = ServletUtil.getParameter(CAPTCHA_CODE);
        if (Strings.isBlank((String)captchaKey)) {
            ServletUtil.writeJson(Result.failure(ResultCode.CAPTCHA_KEY_MISSION));
            return;
        }
        if (Strings.isBlank((String)captchaCode)) {
            ServletUtil.writeJson(Result.failure(ResultCode.CAPTCHA_CODE_MISSION));
            return;
        }
        try {
            this.customCaptchaService.verifyCaptcha(captchaKey, captchaCode);
        }
        catch (CaptchaExpiredException e) {
            ServletUtil.writeJson(Result.failure(ResultCode.CAPTCHA_EXPIRED));
            return;
        }
        catch (CaptchaValidationException e) {
            ServletUtil.writeJson(Result.failure(ResultCode.CAPTCHA_INVALID));
            return;
        }
        this.customCaptchaService.destroyCaptcha(captchaKey);
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    protected boolean shouldNotFilter(HttpServletRequest request) throws ServletException {
        if (SecurityConstant.IS_CAPTCHA_VERIFICATION.booleanValue()) {
            return !request.getRequestURI().equals("/api/login") || !request.getMethod().equals("POST");
        }
        return true;
    }
}

