/*
 * Decompiled with CFR 0.152.
 */
package me.youm.boot.secure.services;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import me.youm.boot.secure.domain.SysPower;
import me.youm.boot.secure.domain.SysRole;
import me.youm.boot.secure.domain.SysUser;
import me.youm.boot.secure.services.IPowerService;
import me.youm.boot.secure.services.IUserService;
import me.youm.boot.secure.services.SecureUser;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Component;

@Component
public class SecureUserServiceImpl
implements UserDetailsService {
    @Resource
    private IUserService userService;
    @Resource
    private IPowerService powerService;

    public SecureUser loadUserByUsername(String username) throws UsernameNotFoundException {
        SysUser sysUser = this.userService.selectByUsername(username);
        if (sysUser == null) {
            throw new UsernameNotFoundException("USERNAME NOT SUPPORT");
        }
        sysUser.setAuthorities(this.loadAuthorities(sysUser.getId()));
        sysUser.setRoles(this.loadRoles(sysUser.getId()));
        return sysUser;
    }

    public Set<? extends GrantedAuthority> loadAuthorities(String userId) {
        HashSet<SimpleGrantedAuthority> authoritySet = new HashSet<SimpleGrantedAuthority>();
        List<SysPower> powers = this.powerService.power(userId);
        for (SysPower power : powers) {
            SimpleGrantedAuthority authority = new SimpleGrantedAuthority(power.getCode());
            authoritySet.add(authority);
        }
        return authoritySet;
    }

    public List<SysRole> loadRoles(String userId) {
        return this.userService.role(userId);
    }
}

