/*
 * Decompiled with CFR 0.152.
 */
package me.youm.boot.secure.uutoken;

import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import me.youm.boot.secure.services.SecureUser;
import me.youm.boot.secure.uutoken.SecureUserToken;
import me.youm.boot.tools.core.TokenUtil;
import me.youm.boot.web.exception.auth.token.TokenException;
import me.youm.boot.web.exception.auth.token.TokenExpiredException;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class SecureUserTokenService {
    @Resource
    private RedisTemplate<String, SecureUserToken> redisTemplate;

    public SecureUserToken createToken(SecureUser secureUser) {
        SecureUserToken userToken = new SecureUserToken();
        userToken.setToken(TokenUtil.create(secureUser.getId(), secureUser.getUsername()));
        userToken.setSecureUser(secureUser);
        return userToken;
    }

    public String saveToken(SecureUserToken userToken) {
        String key = String.valueOf(UUID.randomUUID());
        this.redisTemplate.opsForValue().set((Object)("TOKEN-" + key), (Object)userToken, 1800000L, TimeUnit.SECONDS);
        return key;
    }

    public SecureUserToken verifyToken(String key, String token) throws TokenException {
        SecureUserToken secureUserToken = this.taskToken(key);
        if (secureUserToken == null) {
            throw new TokenExpiredException("token expired");
        }
        TokenUtil.parse(secureUserToken.getToken());
        return secureUserToken;
    }

    public SecureUserToken taskToken(String key) {
        return (SecureUserToken)this.redisTemplate.opsForValue().get((Object)("TOKEN-" + key));
    }

    public void destroyToken(String key) {
        this.redisTemplate.delete((Object)("TOKEN-" + key));
    }
}

