/*
 * Decompiled with CFR 0.152.
 */
package me.youm.boot.secure.uutoken;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import me.youm.boot.context.BeanContext;
import me.youm.boot.secure.services.SecureUser;
import me.youm.boot.secure.uutoken.SecureUserToken;
import me.youm.boot.secure.uutoken.SecureUserTokenService;
import me.youm.boot.tools.core.PatternUtil;
import me.youm.boot.tools.core.ServletUtil;
import me.youm.boot.web.domain.Result;
import me.youm.boot.web.domain.ResultCode;
import me.youm.boot.web.exception.auth.token.TokenExpiredException;
import me.youm.boot.web.exception.auth.token.TokenValidationException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.filter.OncePerRequestFilter;

public class SecureUserTokenSupport
extends OncePerRequestFilter {
    private final SecureUserTokenService customUserDetailsTokenService = BeanContext.getBean("secureUserTokenService", SecureUserTokenService.class);

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        SecureUser secureUser;
        String tokenHeader = request.getHeader("Authorization");
        String tokenHeaderKey = request.getHeader("Authorization-Key");
        if (tokenHeader == null) {
            ServletUtil.writeJson(Result.failure(ResultCode.TOKEN_MISSION));
            return;
        }
        try {
            SecureUserToken userToken = this.customUserDetailsTokenService.verifyToken(tokenHeaderKey, tokenHeader.replaceFirst("Bearer ", ""));
            secureUser = userToken.getSecureUser();
        }
        catch (TokenValidationException e) {
            ServletUtil.writeJson(Result.failure(ResultCode.TOKEN_INVALID));
            return;
        }
        catch (TokenExpiredException e) {
            ServletUtil.writeJson(Result.failure(ResultCode.TOKEN_EXPIRED));
            return;
        }
        UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken((Object)secureUser, (Object)secureUser.getId(), secureUser.getAuthorities());
        SecurityContextHolder.getContext().setAuthentication((Authentication)authentication);
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    protected boolean shouldNotFilter(HttpServletRequest request) {
        List<String> pattern = Arrays.asList("/webjars/springfox-swagger-ui/fonts/**,/swagger-resources,/swagger-resources/configuration/**,/webjars**,/swagger-ui.html,/webjars/springfox-swagger-ui/**,/v2/api-docs,/api/login,/api/captcha/create".split(","));
        return PatternUtil.matches(pattern, ServletUtil.getRequestURI());
    }
}

