/*
 * Decompiled with CFR 0.152.
 */
package me.youm.boot.tools.core;

import java.util.List;
import java.util.regex.Pattern;

public class PatternUtil {
    public static boolean matches(String pattern, String content) {
        return Pattern.matches(PatternUtil.getRegPath(pattern), content);
    }

    public static boolean matches(String pattern, List<String> content) {
        for (String item : content) {
            if (!PatternUtil.matches(PatternUtil.getRegPath(pattern), item)) continue;
            return true;
        }
        return false;
    }

    public static boolean matches(List<String> pattern, String content) {
        for (String item : pattern) {
            if (!PatternUtil.matches(PatternUtil.getRegPath(item), content)) continue;
            return true;
        }
        return false;
    }

    private static String getRegPath(String path) {
        char[] chars = path.toCharArray();
        int len = chars.length;
        StringBuilder sb = new StringBuilder();
        boolean preX = false;
        for (int i = 0; i < len; ++i) {
            if (chars[i] == '*') {
                if (preX) {
                    sb.append(".*");
                    preX = false;
                    continue;
                }
                if (i + 1 == len) {
                    sb.append("[^/]*");
                    continue;
                }
                preX = true;
                continue;
            }
            if (preX) {
                sb.append("[^/]*");
                preX = false;
            }
            if (chars[i] == '?') {
                sb.append('.');
                continue;
            }
            sb.append(chars[i]);
        }
        return sb.toString();
    }
}

