/*
 * Decompiled with CFR 0.152.
 */
package me.youm.boot.tools.core;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class ServletUtil {
    public static HttpServletRequest getRequest() {
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        assert (servletRequestAttributes != null);
        return servletRequestAttributes.getRequest();
    }

    public static HttpServletResponse getResponse() {
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        assert (servletRequestAttributes != null);
        return servletRequestAttributes.getResponse();
    }

    public static HttpSession getSession() {
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        assert (servletRequestAttributes != null);
        return servletRequestAttributes.getRequest().getSession();
    }

    public static String getParameter(String paramName) {
        return ServletUtil.getRequest().getParameter(paramName);
    }

    public static JSONObject getBodyParameters() {
        try {
            InputStreamReader reader = new InputStreamReader((InputStream)ServletUtil.getRequest().getInputStream(), "UTF-8");
            char[] buff = new char[1024];
            int length = 0;
            String body = null;
            while ((length = reader.read(buff)) != -1) {
                body = new String(buff, 0, length);
            }
            return JSON.parseObject(body);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void write(String msg) throws IOException {
        HttpServletResponse response = ServletUtil.getResponse();
        response.setHeader("Content-type", "application/json;charset=UTF-8");
        response.setCharacterEncoding("UTF-8");
        response.getWriter().write(msg);
    }

    public static void writeJson(Object data) throws IOException {
        ServletUtil.write(JSON.toJSONString((Object)data));
    }

    public static String getQueryParam() {
        return ServletUtil.getRequest().getQueryString();
    }

    public static String getRequestURI() {
        return ServletUtil.getRequest().getRequestURI();
    }

    public static String getRemoteHost() {
        String remoteHost = ServletUtil.getRequest().getRemoteHost();
        if ("0:0:0:0:0:0:0:1".equals(remoteHost)) {
            remoteHost = "127.0.0.1";
        }
        return remoteHost;
    }

    public static String getIpAddress() {
        HttpServletRequest request = ServletUtil.getRequest();
        String ipAddress = request.getHeader("x-forwarded-for");
        if (ipAddress == null || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress)) {
            ipAddress = request.getHeader("Proxy-Client-IP");
        }
        if (ipAddress == null || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress)) {
            ipAddress = request.getHeader("WL-Proxy-Client-IP");
        }
        if ((ipAddress == null || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress)) && ("127.0.0.1".equals(ipAddress = request.getRemoteAddr()) || "0:0:0:0:0:0:0:1".equals(ipAddress))) {
            try {
                ipAddress = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
        }
        if (ipAddress != null && ipAddress.length() > 15 && ipAddress.indexOf(",") > 0) {
            ipAddress = ipAddress.substring(0, ipAddress.indexOf(","));
        }
        return ipAddress;
    }

    public static String getMethod() {
        return ServletUtil.getRequest().getMethod();
    }

    public static String getHeader(String name) {
        return ServletUtil.getRequest().getHeader(name);
    }

    public static String getAgent() {
        return ServletUtil.getHeader("User-Agent");
    }

    public static String getBrowser() {
        String userAgent = ServletUtil.getAgent();
        if (userAgent.contains("Firefox")) {
            return "\u706b\u72d0\u6d4f\u89c8\u5668";
        }
        if (userAgent.contains("Chrome")) {
            return "\u8c37\u6b4c\u6d4f\u89c8\u5668";
        }
        if (userAgent.contains("Trident")) {
            return "IE \u6d4f\u89c8\u5668";
        }
        return "\u4f60\u7528\u5565\u6d4f\u89c8\u5668";
    }

    public static String getSystem() {
        String userAgent = ServletUtil.getAgent();
        if (ServletUtil.getAgent().toLowerCase().contains("windows")) {
            return "Windows";
        }
        if (userAgent.toLowerCase().contains("mac")) {
            return "Mac";
        }
        if (userAgent.toLowerCase().contains("x11")) {
            return "Unix";
        }
        if (userAgent.toLowerCase().contains("android")) {
            return "Android";
        }
        if (userAgent.toLowerCase().contains("iphone")) {
            return "IPhone";
        }
        return "UnKnown, More-Info: " + userAgent;
    }
}

