/*
 * Decompiled with CFR 0.152.
 */
package me.youm.boot.web.base.page;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import me.youm.boot.web.base.page.PageRequest;
import me.youm.boot.web.base.page.PageResponse;

public class Pageable {
    private Pageable() {
    }

    public static <T> List<T> of(List<T> records, int pageIndex, int pageSize) {
        int pageCount;
        if (records == null) {
            return Collections.emptyList();
        }
        int totalCount = records.size();
        int remainder = totalCount % pageSize;
        int n = pageCount = remainder > 0 ? totalCount / pageSize + 1 : totalCount / pageSize;
        if (remainder == 0) {
            return records.stream().skip((long)(pageIndex - 1) * (long)pageSize).limit(pageSize).collect(Collectors.toList());
        }
        if (pageIndex == pageCount) {
            return records.stream().skip((long)(pageIndex - 1) * (long)pageSize).limit(totalCount).collect(Collectors.toList());
        }
        return records.stream().skip((long)(pageIndex - 1) * (long)pageSize).limit(pageSize).collect(Collectors.toList());
    }

    public static <T> PageResponse<T> of(PageRequest request, List<T> records) {
        return new PageResponse<T>(records.size(), Pageable.of(records, request.getPageNum(), request.getPageSize()));
    }

    public static <T> PageResponse<T> of(PageRequest request, Record record) {
        PageHelper.startPage((int)request.getPageNum(), (int)request.getPageSize());
        return new PageResponse(new PageInfo(record.invoke()));
    }

    public static interface Record<T> {
        public List<T> invoke();
    }
}

