/*
 * Decompiled with CFR 0.152.
 */
package me.youm.boot.web.domain;

import me.youm.boot.web.domain.ResultCode;

public class Result<T> {
    private Integer code;
    private String msg;
    private boolean success;
    private Object data;
    private long timeStamp = System.currentTimeMillis();
    private String tokenKey;
    private String token;

    public static <T> Result<T> success() {
        return Result.success("");
    }

    public static <T> Result<T> success(T data) {
        return Result.success(ResultCode.SUCCESS.message(), data);
    }

    public static <T> Result<T> success(String message) {
        return Result.success(message, null);
    }

    public static <T> Result<T> success(String message, T data) {
        return Result.success(ResultCode.SUCCESS.code(), message, data);
    }

    public static <T> Result<T> success(ResultCode resultCode) {
        return Result.success(resultCode.code(), resultCode.message());
    }

    public static <T> Result<T> success(ResultCode resultCode, String tokenKey, String token) {
        Result<T> result = Result.success(resultCode.code(), resultCode.message());
        result.setTokenKey(tokenKey);
        result.setToken(token);
        return result;
    }

    public static <T> Result<T> success(int code, String message) {
        return Result.success(code, message, null);
    }

    public static <T> Result<T> success(int code, String message, T data) {
        return Result.result(code, message, data, true);
    }

    public static <T> Result<T> failure() {
        return Result.failure(ResultCode.FAILURE.message());
    }

    public static <T> Result<T> failure(String message) {
        return Result.failure(message, null);
    }

    public static <T> Result<T> failure(ResultCode resultCode) {
        return Result.failure(resultCode.code(), resultCode.message());
    }

    public static <T> Result<T> failure(String message, T data) {
        return Result.failure(ResultCode.FAILURE.code(), message, data);
    }

    public static <T> Result<T> failure(int code, String message) {
        return Result.failure(code, message, null);
    }

    public static <T> Result<T> failure(int code, String message, T data) {
        return Result.result(code, message, data, false);
    }

    public static <T> Result<T> auto(boolean b) {
        return Result.auto(b, ResultCode.SUCCESS.message(), ResultCode.FAILURE.message());
    }

    public static <T> Result<T> auto(boolean b, String success, String failure) {
        if (b) {
            return Result.success(success);
        }
        return Result.failure(failure);
    }

    public static <T> Result<T> result(int code, String message, T data, boolean success) {
        Result<T> result = new Result<T>();
        result.setCode(code);
        result.setMsg(message);
        result.setSuccess(success);
        result.setTimeStamp(System.currentTimeMillis());
        result.setData(data);
        return result;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public Object getData() {
        return this.data;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public String getTokenKey() {
        return this.tokenKey;
    }

    public String getToken() {
        return this.token;
    }

    public Result<T> setCode(Integer code) {
        this.code = code;
        return this;
    }

    public Result<T> setMsg(String msg) {
        this.msg = msg;
        return this;
    }

    public Result<T> setSuccess(boolean success) {
        this.success = success;
        return this;
    }

    public Result<T> setData(Object data) {
        this.data = data;
        return this;
    }

    public Result<T> setTimeStamp(long timeStamp) {
        this.timeStamp = timeStamp;
        return this;
    }

    public Result<T> setTokenKey(String tokenKey) {
        this.tokenKey = tokenKey;
        return this;
    }

    public Result<T> setToken(String token) {
        this.token = token;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Result)) {
            return false;
        }
        Result other = (Result)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isSuccess() != other.isSuccess()) {
            return false;
        }
        if (this.getTimeStamp() != other.getTimeStamp()) {
            return false;
        }
        Integer this$code = this.getCode();
        Integer other$code = other.getCode();
        if (this$code == null ? other$code != null : !((Object)this$code).equals(other$code)) {
            return false;
        }
        String this$msg = this.getMsg();
        String other$msg = other.getMsg();
        if (this$msg == null ? other$msg != null : !this$msg.equals(other$msg)) {
            return false;
        }
        Object this$data = this.getData();
        Object other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        String this$tokenKey = this.getTokenKey();
        String other$tokenKey = other.getTokenKey();
        if (this$tokenKey == null ? other$tokenKey != null : !this$tokenKey.equals(other$tokenKey)) {
            return false;
        }
        String this$token = this.getToken();
        String other$token = other.getToken();
        return !(this$token == null ? other$token != null : !this$token.equals(other$token));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Result;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSuccess() ? 79 : 97);
        long $timeStamp = this.getTimeStamp();
        result = result * 59 + (int)($timeStamp >>> 32 ^ $timeStamp);
        Integer $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : ((Object)$code).hashCode());
        String $msg = this.getMsg();
        result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
        Object $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        String $tokenKey = this.getTokenKey();
        result = result * 59 + ($tokenKey == null ? 43 : $tokenKey.hashCode());
        String $token = this.getToken();
        result = result * 59 + ($token == null ? 43 : $token.hashCode());
        return result;
    }

    public String toString() {
        return "Result(code=" + this.getCode() + ", msg=" + this.getMsg() + ", success=" + this.isSuccess() + ", data=" + this.getData() + ", timeStamp=" + this.getTimeStamp() + ", tokenKey=" + this.getTokenKey() + ", token=" + this.getToken() + ")";
    }
}

