/*
 * Decompiled with CFR 0.152.
 */
package me.youm.boot.web.exception;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import me.youm.boot.web.domain.Result;
import org.springframework.context.support.DefaultMessageSourceResolvable;
import org.springframework.core.annotation.Order;
import org.springframework.validation.BindException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@Order(value=1)
@RestControllerAdvice
public class ValidationExceptionHandler {
    @ExceptionHandler(value={BindException.class})
    public Result<?> bindExceptionHandler(BindException e) {
        List fieldErrors = e.getBindingResult().getFieldErrors();
        List collect = fieldErrors.stream().map(DefaultMessageSourceResolvable::getDefaultMessage).collect(Collectors.toList());
        return Result.failure(400, "Bad Request", collect);
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public Result<?> methodArgumentNotValidExceptionHandler(MethodArgumentNotValidException e) {
        List fieldErrors = e.getBindingResult().getFieldErrors();
        List collect = fieldErrors.stream().map(DefaultMessageSourceResolvable::getDefaultMessage).collect(Collectors.toList());
        return Result.failure(400, "Bad Request", collect);
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    public Result<?> constraintViolationExceptionHandler(ConstraintViolationException e) {
        Set constraintViolations = e.getConstraintViolations();
        List collect = constraintViolations.stream().map(ConstraintViolation::getMessage).collect(Collectors.toList());
        return Result.failure(400, "Bad Request", collect);
    }
}

