/*
 * Decompiled with CFR 0.152.
 */
package me.youm.boot.web.interceptor;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import me.youm.boot.context.BeanContext;
import me.youm.boot.context.UserContext;
import me.youm.boot.secure.domain.SysDept;
import me.youm.boot.secure.domain.SysRole;
import me.youm.boot.secure.services.IDeptService;
import me.youm.boot.secure.services.IUserService;
import me.youm.boot.web.interceptor.InvocationHandler;
import me.youm.boot.web.interceptor.annotation.DataScope;
import me.youm.boot.web.interceptor.annotation.DataScopeRule;
import me.youm.boot.web.interceptor.enums.Scope;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.apache.logging.log4j.util.Strings;

@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class, CacheKey.class, BoundSql.class})})
public class DataScopeInterceptor
implements Interceptor {
    public Object intercept(Invocation invocation) throws Throwable {
        UserContext userContext = BeanContext.getBean(UserContext.class);
        try {
            MappedStatement mappedStatement = InvocationHandler.getMappedStatement(invocation);
            DataScope annotation = this.getAnnotation(mappedStatement);
            if (annotation != null) {
                String sql = InvocationHandler.getSql(invocation);
                DataScopeRule[] rules = annotation.rules();
                sql = this.preHandler(sql);
                Object where = "";
                if (rules.length > 0) {
                    List<SysRole> roles = userContext.getRoles();
                    List<Scope> scopes = this.getScope(roles, rules);
                    for (Scope scopeItem : scopes) {
                        where = (String)where + this.sqlHandler(scopeItem);
                    }
                } else {
                    Scope scope = annotation.scope();
                    if (Scope.AUTO.equals((Object)scope)) {
                        List<SysRole> roles = userContext.getRoles();
                        List<Scope> scopes = this.getScope(roles);
                        for (Scope scopeItem : scopes) {
                            where = (String)where + this.sqlHandler(scopeItem);
                        }
                    } else {
                        where = (String)where + this.sqlHandler(scope);
                    }
                }
                sql = this.aftHandler(sql, (String)where);
                InvocationHandler.setSql(invocation, sql);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return invocation.proceed();
    }

    private List<Scope> getScope(List<SysRole> roles) {
        return roles.stream().map(SysRole::getScope).collect(Collectors.toList());
    }

    private List<Scope> getScope(List<SysRole> roles, DataScopeRule[] rules) {
        ArrayList<Scope> scopes = new ArrayList<Scope>();
        for (SysRole role : roles) {
            for (DataScopeRule rule : rules) {
                if (!role.getCode().equals(rule.role())) continue;
                scopes.add(rule.scope());
            }
        }
        return scopes;
    }

    private String preHandler(String sql) {
        if (((String)sql).contains("order")) {
            sql = (String)sql + " limit 9999";
        }
        sql = "select * from (" + (String)sql + ") data left join sys_user b on b.id = data.create_by";
        return sql;
    }

    private String aftHandler(String sql, String where) {
        if (Strings.isNotBlank((String)where)) {
            where = where.replaceFirst("or", "");
            sql = (String)sql + " where " + where;
        }
        return sql;
    }

    private String sqlHandler(Scope scope) {
        IDeptService deptService = BeanContext.getBean(IDeptService.class);
        IUserService userService = BeanContext.getBean(IUserService.class);
        UserContext userContext = BeanContext.getBean(UserContext.class);
        String userId = userContext.getUserId();
        String deptId = userContext.getDeptId();
        if (Scope.SELF.equals((Object)scope)) {
            return "or data.create_by = " + userId;
        }
        if (Scope.DEPT.equals((Object)scope)) {
            return "or b.dept_id = " + deptId;
        }
        if (Scope.DEPT_CHILD.equals((Object)scope)) {
            return "or b.dept_id in (" + this.convertDept(deptService.treeAndChildren(deptId)) + ")";
        }
        if (Scope.CUSTOM.equals((Object)scope)) {
            return "or b.dept_id in (" + this.convertDept(userService.dept(userId)) + ")";
        }
        return "";
    }

    private DataScope getAnnotation(MappedStatement mappedStatement) throws ClassNotFoundException {
        Method[] method;
        DataScope dataAuth = null;
        String id = mappedStatement.getId();
        String className = id.substring(0, id.lastIndexOf("."));
        String methodName = id.substring(id.lastIndexOf(".") + 1, id.length());
        Class<?> cls = Class.forName(className);
        for (Method me : method = cls.getMethods()) {
            if (!me.getName().equals(methodName)) continue;
            dataAuth = me.getAnnotation(DataScope.class);
        }
        return dataAuth;
    }

    private String convertDept(List<SysDept> deptList) {
        List deptIds = deptList.stream().map(d -> d.getId()).collect(Collectors.toList());
        return StringUtils.join(deptIds, (String)",");
    }
}

