/*
 * Decompiled with CFR 0.152.
 */
package me.youm.boot.web.interceptor;

import java.util.List;
import javax.annotation.Resource;
import me.youm.boot.constant.TenantConstant;
import me.youm.boot.web.interceptor.DataScopeInterceptor;
import me.youm.boot.web.interceptor.TenantInterceptor;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.SqlSessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.ContextRefreshedEvent;

@Configuration
public class InterceptorConfiguration
implements ApplicationListener<ContextRefreshedEvent> {
    private static final Logger log = LoggerFactory.getLogger(InterceptorConfiguration.class);
    @Resource
    private List<SqlSessionFactory> sqlSessionFactoryList;

    public void onApplicationEvent(ContextRefreshedEvent event) {
        this.addMyInterceptor();
    }

    private void addMyInterceptor() {
        for (SqlSessionFactory sqlSessionFactory : this.sqlSessionFactoryList) {
            if (TenantConstant.enable) {
                log.info("Enable multi tenant");
                sqlSessionFactory.getConfiguration().addInterceptor((Interceptor)new TenantInterceptor());
            }
            sqlSessionFactory.getConfiguration().addInterceptor((Interceptor)new DataScopeInterceptor());
        }
    }
}

