/*
 * Decompiled with CFR 0.152.
 */
package me.youm.boot.web.interceptor;

import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import me.youm.boot.tools.core.ServletUtil;
import me.youm.boot.web.interceptor.annotation.RateLimit;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;

@Component
public class RateLimitInterceptor
implements HandlerInterceptor {
    @Resource
    private RedisTemplate<String, Long> redisTemplate;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        HandlerMethod handlerMethod;
        RateLimit currentLimit;
        if (handler instanceof HandlerMethod && (currentLimit = (RateLimit)(handlerMethod = (HandlerMethod)handler).getMethodAnnotation(RateLimit.class)) != null) {
            int number = currentLimit.number();
            long time = currentLimit.time();
            System.out.println("\u9650\u6d41\u65f6\u95f4:" + time);
            if (time > 0L && number > 0) {
                String key = request.getContextPath() + ":" + request.getServletPath() + ":" + ServletUtil.getIpAddress();
                Long numberRedis = (Long)this.redisTemplate.opsForValue().get((Object)key);
                Long timeRedis = this.redisTemplate.getExpire((Object)key);
                if (null == numberRedis) {
                    this.redisTemplate.opsForValue().set((Object)key, (Object)1L, time, TimeUnit.SECONDS);
                    return true;
                }
                if (numberRedis >= (long)number) {
                    throw new RuntimeException("\u8bf7\u6c42\u9891\u7e41\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
                }
                this.redisTemplate.opsForValue().set((Object)key, (Object)(numberRedis + 1L), timeRedis.longValue(), TimeUnit.SECONDS);
            }
        }
        return true;
    }
}

