/*
 * Decompiled with CFR 0.152.
 */
package me.youm.boot.web.interceptor;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import me.youm.boot.constant.TenantConstant;
import me.youm.boot.context.BeanContext;
import me.youm.boot.context.UserContext;
import me.youm.boot.web.interceptor.InvocationHandler;
import me.youm.boot.web.interceptor.annotation.TenantIgnore;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.BinaryExpression;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.insert.Insert;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.update.Update;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;

@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class}), @Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class})})
public class TenantInterceptor
implements Interceptor {
    public Object intercept(Invocation invocation) throws Throwable {
        if (this.getAnnotation(InvocationHandler.getMappedStatement(invocation)) == null) {
            String sql = InvocationHandler.getSql(invocation);
            sql = this.addWhere(sql);
            InvocationHandler.setSql(invocation, sql);
        }
        return invocation.proceed();
    }

    public String addWhere(String sql) throws JSQLParserException {
        UserContext userContext = BeanContext.getBean(UserContext.class);
        Statement stmt = CCJSqlParserUtil.parse((String)sql);
        if (stmt instanceof Insert) {
            Insert insert = (Insert)stmt;
            Table table = insert.getTable();
            List columns = insert.getColumns();
            boolean flag = true;
            for (Column column : columns) {
                if (!column.getName(false).equals(TenantConstant.TENANT_COLUMN)) continue;
                flag = false;
            }
            if (!Arrays.asList(TenantConstant.IGNORE_TABLE).contains(table.getName()) && flag) {
                insert.getColumns().add(new Column(TenantConstant.TENANT_COLUMN));
                ((ExpressionList)insert.getItemsList()).getExpressions().add(new StringValue(userContext.getPrincipal().getTenantId()));
            }
            return insert.toString();
        }
        if (stmt instanceof Update) {
            Expression where;
            Update updateStatement = (Update)stmt;
            Table table = updateStatement.getTable();
            if (!Arrays.asList(TenantConstant.IGNORE_TABLE).contains(table.getName()) && (where = updateStatement.getWhere()) instanceof BinaryExpression) {
                EqualsTo equalsTo = new EqualsTo();
                equalsTo.setLeftExpression((Expression)new Column(TenantConstant.TENANT_COLUMN));
                equalsTo.setRightExpression((Expression)new StringValue(userContext.getPrincipal().getTenantId()));
                AndExpression andExpression = new AndExpression((Expression)equalsTo, where);
                updateStatement.setWhere((Expression)andExpression);
            }
            return updateStatement.toString();
        }
        if (stmt instanceof Select) {
            Select select = (Select)stmt;
            PlainSelect ps = (PlainSelect)select.getSelectBody();
            Table mainTable = (Table)ps.getFromItem();
            TableAlias mainTableAlias = new TableAlias();
            mainTableAlias.setAlias(mainTable.getAlias() == null ? null : mainTable.getAlias().getName());
            mainTableAlias.setTable(mainTable.getName());
            if (!Arrays.asList(TenantConstant.IGNORE_TABLE).contains(mainTableAlias.getTable())) {
                EqualsTo equalsTo = new EqualsTo();
                equalsTo.setLeftExpression((Expression)new Column((mainTableAlias.getAlias() == null ? mainTableAlias.getTable() : mainTableAlias.getAlias()) + "." + TenantConstant.TENANT_COLUMN));
                equalsTo.setRightExpression((Expression)new StringValue(userContext.getPrincipal().getTenantId()));
                if (ps.getWhere() == null) {
                    EqualsTo replaceWhere = new EqualsTo();
                    replaceWhere.setLeftExpression((Expression)new Column("1"));
                    replaceWhere.setRightExpression((Expression)new LongValue(1L));
                    AndExpression andExpression = new AndExpression((Expression)equalsTo, (Expression)replaceWhere);
                    ps.setWhere((Expression)andExpression);
                } else {
                    AndExpression andExpression = new AndExpression((Expression)equalsTo, ps.getWhere());
                    ps.setWhere((Expression)andExpression);
                }
            }
            return select.toString();
        }
        return sql;
    }

    private TenantIgnore getAnnotation(MappedStatement mappedStatement) {
        TenantIgnore tenantIgnore = null;
        try {
            Method[] method;
            String id = mappedStatement.getId();
            String className = id.substring(0, id.lastIndexOf("."));
            String methodName = id.substring(id.lastIndexOf(".") + 1, id.length());
            Class<?> cls = Class.forName(className);
            for (Method me : method = cls.getMethods()) {
                if (!me.getName().equals(methodName)) continue;
                tenantIgnore = me.getAnnotation(TenantIgnore.class);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tenantIgnore;
    }

    static class TableAlias {
        private String table;
        private String alias;

        public String getTable() {
            return this.table;
        }

        public String getAlias() {
            return this.alias;
        }

        public void setTable(String table) {
            this.table = table;
        }

        public void setAlias(String alias) {
            this.alias = alias;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TableAlias)) {
                return false;
            }
            TableAlias other = (TableAlias)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$table = this.getTable();
            String other$table = other.getTable();
            if (this$table == null ? other$table != null : !this$table.equals(other$table)) {
                return false;
            }
            String this$alias = this.getAlias();
            String other$alias = other.getAlias();
            return !(this$alias == null ? other$alias != null : !this$alias.equals(other$alias));
        }

        protected boolean canEqual(Object other) {
            return other instanceof TableAlias;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $table = this.getTable();
            result = result * 59 + ($table == null ? 43 : $table.hashCode());
            String $alias = this.getAlias();
            result = result * 59 + ($alias == null ? 43 : $alias.hashCode());
            return result;
        }

        public String toString() {
            return "TenantInterceptor.TableAlias(table=" + this.getTable() + ", alias=" + this.getAlias() + ")";
        }
    }
}

