package me.youm.core.auth.config;

import me.youm.core.auth.props.TokenProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

/**
 * @author youta
 */
@Configuration
@ComponentScan(value = "me.youm.core.auth")
@EnableConfigurationProperties(TokenProperties.class)
@ConditionalOnProperty(value = TokenProperties.PREFIX + ".enable", havingValue = "true", matchIfMissing = true)
public class TokenConfiguration {
}
