/*
 * Decompiled with CFR 0.152.
 */
package me.youm.core.cache.providers;

import java.time.Duration;
import java.util.Optional;
import me.youm.core.cache.ReactiveCacheProvider;
import me.youm.core.cache.model.CacheType;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Mono;

@Component
public class SpringCacheableProvider
implements ReactiveCacheProvider {
    private final CacheManager cacheManager;
    private static final String CACHE_NAME = "rcache";

    @Override
    public Mono<Object> lookup(Object request, String cachePrefix) {
        return this.getCache().map(cache -> cache.get((Object)request.toString())).map(Cache.ValueWrapper::get).map(Mono::justOrEmpty).orElse(Mono.empty());
    }

    @Override
    public Mono<Boolean> save(Object request, Object response, String cachePrefix, Duration ttl) {
        this.getCache().ifPresent(cache -> cache.put((Object)request.toString(), response));
        return Mono.just((Object)true);
    }

    private Optional<Cache> getCache() {
        return Optional.ofNullable(this.cacheManager.getCache(CACHE_NAME));
    }

    @Override
    public CacheType cacheType() {
        return CacheType.LOCAL;
    }

    public SpringCacheableProvider(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }
}

