package me.youm.core.common.constants;

import lombok.experimental.UtilityClass;

/**
 * @author youta
 */
@UtilityClass
public class MyConstant {

    /**
     * 应用版本号
     */
    public static final String MY_APP_VERSION = "v1";

    /**
     * Spring 应用名 prop key
     */
    public static final String SPRING_APP_NAME_KEY = "spring.application.name";


    /**
     * 默认为空消息
     */
    public static final String DEFAULT_NULL_MESSAGE = "承载数据为空";
    /**
     * 默认成功消息
     */
    public static final String DEFAULT_SUCCESS_MESSAGE = "处理成功";
    /**
     * 默认失败消息
     */
    public static final String DEFAULT_FAIL_MESSAGE = "处理失败";
    /**
     * 树的根节点值
     */
    public static final Long TREE_ROOT = -1L;
    /**
     * 允许的文件类型，可根据需求添加
     */
    public static final String[] VALID_FILE_TYPE = {"xlsx", "zip"};

    public static final String DATETIME_FORMAT = "yyyy-MM-dd HH:mm:ss";

    /**
     * 微服务之间传递的唯一标识
     */
    public static final String MINE_TRACE_ID = "mine-trace-id";

    /**
     * 日志链路追踪id日志标志
     */
    public static final String LOG_TRACE_ID = "traceId";

    /**
     * Java默认临时目录
     */
    public static final String JAVA_TEMP_DIR = "java.io.tmpdir";

    /**
     * 版本
     */
    public static final String VERSION = "version";

    /**
     * 默认版本号
     */
    public static final String DEFAULT_VERSION = "v1";

    /**
     * 服务资源
     */
    public static final String MINE_SERVICE_RESOURCE = "mine-service-resource";

    /**
     * API资源
     */
    public static final String MINE_API_RESOURCE = "mine-api-resource";

    /**
     * 权限认证的排序
     */
    public static final int MINE_UAA_FILTER_ORDER = -200;

    /**
     * 签名排序
     */
    public static final int MINE_SIGN_FILTER_ORDER = -300;

    /**
     * json类型报文，UTF-8字符集
     */
    public static final String JSON_UTF8 = "application/json;charset=UTF-8";


    public static final String ASC = "asc";

    public static final String DESC = "desc";

    public String GATEWAY_TOKEN_HEADER = "GatewayToken";

    /**
     * Gateway请求头TOKEN值
     */
    public String GATEWAY_TOKEN_VALUE = "gateway:123456";
}
