package me.youm.core.common.exception;

import java.text.MessageFormat;

/**
 * 基础异常
 *
 * @author youta
 */
public class BaseException extends RuntimeException {
    protected String msg;
    protected int code;

    protected BaseException(String message) {
        super(message);
    }

    protected BaseException(int code, String msgFormat, Object... args) {
        super(MessageFormat.format(msgFormat, args));
        this.code = code;
        this.msg = MessageFormat.format(msgFormat, args);
    }

    public String getMsg() {
        return this.msg;
    }

    public int getCode() {
        return this.code;
    }
}