package me.youm.core.common.utils;

import cn.hutool.core.util.ReflectUtil;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;

import java.util.HashSet;
import java.util.Set;

/**
 * @author youta
 */
public class BeanUtil {

    /**
     * source属性为空的不赋值给target
     *
     * @param source 源头
     * @param tClass 目标类型
     * @return T 目标
     */
    public static <T> T copyProperties(Object source, Class<T> tClass) {
        T target = ReflectUtil.newInstanceIfPossible(tClass);
        BeanUtils.copyProperties(source, target, getNullPropertyNames(source));
        return target;
    }

    /**
     * source属性为空的不赋值给target
     *
     * @param source 源头
     * @param target 目标类型
     * @return T 目标
     */
    public static <T> T copyProperties(Object source, T target) {
        BeanUtils.copyProperties(source, target, getNullPropertyNames(source));
        return target;
    }


    private static String[] getNullPropertyNames(Object source) {
        final BeanWrapper src = new BeanWrapperImpl(source);
        java.beans.PropertyDescriptor[] pds = src.getPropertyDescriptors();

        Set<String> emptyNames = new HashSet<>();
        for (java.beans.PropertyDescriptor pd : pds) {
            Object srcValue = src.getPropertyValue(pd.getName());
            if (srcValue == null) emptyNames.add(pd.getName());
        }
        String[] result = new String[emptyNames.size()];
        return emptyNames.toArray(result);
    }

}
