package me.youm.core.mqtt;

import org.springframework.integration.annotation.MessagingGateway;
import org.springframework.integration.mqtt.support.MqttHeaders;
import org.springframework.messaging.handler.annotation.Header;

/**
 * @author youta
 */
@MessagingGateway(defaultRequestChannel = "mqttOutboundChannel")
public interface MqttGateway {

    // 不设置转换器这里以byte[]做参数会报错，需要发送消息，直接调用这个方法即可

    /**
     * 推送消息
     *
     * @param data  数据
     * @param topic 主题
     */
    void sendToMqtt(byte[] data, @Header(MqttHeaders.TOPIC) String topic);

    /**
     * 推送消息
     *
     * @param data  数据
     * @param topic 主题
     * @param qos   qos
     */
    void sendToMqtt(byte[] data, @Header(MqttHeaders.TOPIC) String topic, @Header(MqttHeaders.QOS) int qos);

    /**
     * 推送消息
     *
     * @param data     数据
     * @param topic    主题
     * @param qos      qos
     * @param isRetain isRetain
     */
    void sendToMqtt(byte[] data, @Header(MqttHeaders.TOPIC) String topic, @Header(MqttHeaders.QOS) int qos, @Header(MqttHeaders.RETAINED) boolean isRetain);
}
