package me.youm.core.mqtt.handler;

import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandler;
import org.springframework.stereotype.Component;

import java.util.Objects;

/**
 * @author youta
 */
@Component(value = "defaultMessageHandler")
@Slf4j
@AllArgsConstructor
@ConditionalOnProperty(value = "spring.mqtt.enable", havingValue = "true", matchIfMissing = true)
public class DefaultReceivedMessageHandler implements MessageHandler {

    private final MqttManager manager;

    @Override
    public void handleMessage(Message<?> message) {
        log.info("receive subscription messages: ==> [{}]", message);
        String topic = Objects.requireNonNull(message.getHeaders().get("mqtt_receivedTopic")).toString();
        log.info("messages topic：==> [{}]", topic);
        Object payLoad = message.getPayload();
        // 如果不设置转换器这里强转byte[]会报错
        byte[] data = (byte[]) payLoad;
        String content = new String(data);
        log.info("Message is : ==> [{}]", content);
        this.manager.handle(topic, sender -> sender.handleMessage(topic, content));
    }
}