package me.youm.core.mqtt.handler;

import lombok.AllArgsConstructor;
import me.youm.core.common.enums.ApiExceptionEnum;
import me.youm.core.common.exception.BusinessException;
import me.youm.core.mqtt.MqttEventHandler;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;

/**
 * @author youta
 */
@Service
@AllArgsConstructor
@ConditionalOnProperty(value = "youm.mqtt.enable", havingValue = "true", matchIfMissing = true)
public class MqttManager {

    private final List<MqttEventHandler> handlers;

    public Optional<MqttEventHandler> initialize(String topic) {
        return handlers.stream()
                .filter(handler -> topic.startsWith(Optional.of(handler.getTopic()).get())).findAny();
    }

    public void handle(String topic, Consumer<MqttEventHandler> consumer) {
        if (topic == null || "".equals(topic)) {
            throw new BusinessException(ApiExceptionEnum.PARAM_ERROR);
        }
        initialize(topic).ifPresent(consumer);
    }
}
