/*
 * Decompiled with CFR 0.152.
 */
package me.youm.core.mqtt.config;

import javax.annotation.Resource;
import me.youm.core.mqtt.props.MqttCommonProperties;
import me.youm.core.mqtt.props.MqttInboundProperties;
import me.youm.core.mqtt.props.MqttOutboundProperties;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.integration.annotation.ServiceActivator;
import org.springframework.integration.channel.DirectChannel;
import org.springframework.integration.core.MessageProducer;
import org.springframework.integration.mqtt.core.DefaultMqttPahoClientFactory;
import org.springframework.integration.mqtt.core.MqttPahoClientFactory;
import org.springframework.integration.mqtt.inbound.MqttPahoMessageDrivenChannelAdapter;
import org.springframework.integration.mqtt.outbound.MqttPahoMessageHandler;
import org.springframework.integration.mqtt.support.DefaultPahoMessageConverter;
import org.springframework.integration.mqtt.support.MqttMessageConverter;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.util.ObjectUtils;

@ConditionalOnClass(value={MqttConnectOptions.class})
@Configuration
@EnableConfigurationProperties(value={MqttInboundProperties.class, MqttOutboundProperties.class, MqttCommonProperties.class})
@ConditionalOnProperty(value={"youm.mqtt.enable"}, havingValue="true", matchIfMissing=true)
public class MqttClientAutoConfiguration {
    MqttPahoMessageDrivenChannelAdapter adapter;
    @Resource
    MqttInboundProperties mqttInboundProperties;
    @Resource
    MqttOutboundProperties mqttOutboundProperties;
    @Resource
    MqttCommonProperties mqttCommonProperties;
    @Resource
    @Qualifier(value="defaultMessageHandler")
    private MessageHandler defaultMessageHandler;

    @Bean
    public MqttConnectOptions mqttConnectOptions() {
        MqttConnectOptions mqttConnectOptions = new MqttConnectOptions();
        mqttConnectOptions.setUserName(this.mqttCommonProperties.getUserName());
        mqttConnectOptions.setPassword(this.mqttCommonProperties.getPassword().toCharArray());
        mqttConnectOptions.setServerURIs(new String[]{this.mqttCommonProperties.getUrl()});
        mqttConnectOptions.setKeepAliveInterval(2);
        return mqttConnectOptions;
    }

    @Bean
    public MqttPahoClientFactory mqttClientFactory(@Autowired MqttConnectOptions mqttConnectOptions) {
        DefaultMqttPahoClientFactory factory = new DefaultMqttPahoClientFactory();
        factory.setConnectionOptions(mqttConnectOptions);
        return factory;
    }

    @Bean
    @ServiceActivator(inputChannel="mqttOutboundChannel")
    public MessageHandler mqttOutbound(@Autowired MqttConnectOptions mqttConnectOptions) {
        MqttPahoMessageHandler messageHandler = new MqttPahoMessageHandler(this.mqttOutboundProperties.getClientId(), this.mqttClientFactory(mqttConnectOptions));
        messageHandler.setAsync(true);
        messageHandler.setDefaultTopic(this.mqttOutboundProperties.getTopics());
        DefaultPahoMessageConverter converter = new DefaultPahoMessageConverter();
        converter.setPayloadAsBytes(true);
        messageHandler.setConverter((MessageConverter)converter);
        return messageHandler;
    }

    @Bean
    public MessageChannel mqttOutboundChannel() {
        return new DirectChannel();
    }

    @Bean
    public MessageChannel mqttInputChannel() {
        return new DirectChannel();
    }

    @Bean
    public MessageProducer inbound(@Autowired MqttConnectOptions mqttConnectOptions) {
        this.adapter = new MqttPahoMessageDrivenChannelAdapter(this.mqttInboundProperties.getClientId(), this.mqttClientFactory(mqttConnectOptions), new String[]{this.mqttInboundProperties.getTopics()});
        DefaultPahoMessageConverter converter = new DefaultPahoMessageConverter();
        converter.setPayloadAsBytes(true);
        this.adapter.setConverter((MqttMessageConverter)converter);
        this.adapter.setQos(new int[]{1});
        this.adapter.setOutputChannel(this.mqttInputChannel());
        return this.adapter;
    }

    @Bean
    @ServiceActivator(inputChannel="mqttInputChannel")
    public MessageHandler handler() {
        return this.defaultMessageHandler;
    }

    public void addTopics(String ... topicNames) {
        if (!ObjectUtils.isEmpty((Object[])topicNames) && topicNames.length > 0) {
            for (String topic : topicNames) {
                this.adapter.addTopic(new String[]{topic});
            }
        }
    }

    public void removeTopic(String ... topicNames) {
        if (!ObjectUtils.isEmpty((Object[])topicNames) && topicNames.length > 0) {
            for (String topicName : topicNames) {
                this.adapter.removeTopic(new String[]{topicName});
            }
        }
    }
}

