/*
 * Decompiled with CFR 0.152.
 */
package me.youm.core.mqtt.handler;

import java.util.Objects;
import me.youm.core.mqtt.handler.MqttManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandler;
import org.springframework.stereotype.Component;

@Component(value="defaultMessageHandler")
@ConditionalOnProperty(value={"spring.mqtt.enable"}, havingValue="true", matchIfMissing=true)
public class DefaultReceivedMessageHandler
implements MessageHandler {
    private static final Logger log = LoggerFactory.getLogger(DefaultReceivedMessageHandler.class);
    private final MqttManager manager;

    public void handleMessage(Message<?> message) {
        log.info("receive subscription messages: ==> [{}]", message);
        String topic = Objects.requireNonNull(message.getHeaders().get((Object)"mqtt_receivedTopic")).toString();
        log.info("messages topic\uff1a==> [{}]", (Object)topic);
        Object payLoad = message.getPayload();
        byte[] data = (byte[])payLoad;
        String content = new String(data);
        log.info("Message is : ==> [{}]", (Object)content);
        this.manager.handle(topic, sender -> sender.handleMessage(topic, content));
    }

    public DefaultReceivedMessageHandler(MqttManager manager) {
        this.manager = manager;
    }
}

