/*
 * Decompiled with CFR 0.152.
 */
package me.youm.core.mqtt.handler;

import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import me.youm.core.common.enums.ApiExceptionEnum;
import me.youm.core.common.enums.EnumInterface;
import me.youm.core.common.exception.BusinessException;
import me.youm.core.mqtt.MqttEventHandler;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(value={"youm.mqtt.enable"}, havingValue="true", matchIfMissing=true)
public class MqttManager {
    private final List<MqttEventHandler> handlers;

    public Optional<MqttEventHandler> initialize(String topic) {
        return this.handlers.stream().filter(handler -> topic.startsWith(Optional.of(handler.getTopic()).get())).findAny();
    }

    public void handle(String topic, Consumer<MqttEventHandler> consumer) {
        if (topic == null || "".equals(topic)) {
            throw new BusinessException((EnumInterface)ApiExceptionEnum.PARAM_ERROR, new Object[0]);
        }
        this.initialize(topic).ifPresent(consumer);
    }

    public MqttManager(List<MqttEventHandler> handlers) {
        this.handlers = handlers;
    }
}

