/*
 * Decompiled with CFR 0.152.
 */
package me.youm.core.redis.config;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.jsontype.PolymorphicTypeValidator;
import com.fasterxml.jackson.databind.jsontype.impl.LaissezFaireSubTypeValidator;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import me.youm.core.redis.service.ReactiveRedisService;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.data.redis.connection.ReactiveRedisConnectionFactory;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory;
import org.springframework.data.redis.core.ReactiveRedisTemplate;
import org.springframework.data.redis.serializer.GenericJackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializationContext;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;

@Configuration
public class ReactiveRedisConfig {
    @Bean
    @Primary
    public RedisSerializer<Object> redisSerializer() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        objectMapper.configure(DeserializationFeature.FAIL_ON_INVALID_SUBTYPE, false);
        objectMapper.configure(SerializationFeature.WRITE_DATE_KEYS_AS_TIMESTAMPS, false);
        objectMapper.registerModule((Module)new JavaTimeModule());
        objectMapper.activateDefaultTyping((PolymorphicTypeValidator)LaissezFaireSubTypeValidator.instance, ObjectMapper.DefaultTyping.NON_FINAL, JsonTypeInfo.As.PROPERTY);
        GenericJackson2JsonRedisSerializer.registerNullValueSerializer((ObjectMapper)objectMapper, null);
        return new GenericJackson2JsonRedisSerializer(objectMapper);
    }

    @Bean
    @Primary
    public RedisSerializationContext<String, Object> redisSerializationContext(final RedisSerializer<Object> redisSerializer) {
        return new RedisSerializationContext<String, Object>(){

            private RedisSerializationContext.SerializationPair<String> getStringPair() {
                return RedisSerializationContext.SerializationPair.fromSerializer((RedisSerializer)StringRedisSerializer.UTF_8);
            }

            private RedisSerializationContext.SerializationPair<Object> getObjectPair() {
                return RedisSerializationContext.SerializationPair.fromSerializer((RedisSerializer)redisSerializer);
            }

            public RedisSerializationContext.SerializationPair<String> getKeySerializationPair() {
                return this.getStringPair();
            }

            public RedisSerializationContext.SerializationPair<Object> getValueSerializationPair() {
                return this.getObjectPair();
            }

            public RedisSerializationContext.SerializationPair<Object> getHashKeySerializationPair() {
                return this.getObjectPair();
            }

            public RedisSerializationContext.SerializationPair<Object> getHashValueSerializationPair() {
                return this.getObjectPair();
            }

            public RedisSerializationContext.SerializationPair<String> getStringSerializationPair() {
                return this.getStringPair();
            }
        };
    }

    @Bean
    @Primary
    public ReactiveRedisTemplate<String, Object> reactiveRedisTemplate(LettuceConnectionFactory factory, RedisSerializationContext<String, Object> context) {
        return new ReactiveRedisTemplate((ReactiveRedisConnectionFactory)factory, context);
    }

    @Bean
    @ConditionalOnBean(name={"reactiveRedisTemplate"})
    public ReactiveRedisService reactiveRedisService() {
        return new ReactiveRedisService();
    }
}

