/*
 * Decompiled with CFR 0.152.
 */
package me.youm.core.redis.service;

import java.time.Duration;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.ReactiveRedisTemplate;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactiveRedisService {
    private static final Logger log = LoggerFactory.getLogger(ReactiveRedisService.class);
    @Autowired
    private ReactiveRedisTemplate<String, Object> redisTemplate;

    public Mono<Boolean> expire(String key, Duration timeout) {
        return this.redisTemplate.expire((Object)key, timeout);
    }

    public Mono<Boolean> hasKey(String key) {
        return this.redisTemplate.hasKey((Object)key);
    }

    public Mono<Long> del(String key) {
        return this.redisTemplate.delete((Object[])new String[]{key});
    }

    public Mono<Object> get(String key) {
        return key == null ? Mono.empty() : this.redisTemplate.opsForValue().get((Object)key);
    }

    public Mono<Boolean> set(String key, Object value) {
        return this.redisTemplate.opsForValue().set((Object)key, value);
    }

    public Mono<Boolean> set(String key, Object value, Duration time) {
        return this.redisTemplate.opsForValue().set((Object)key, value, time);
    }

    public Mono<Object> hashGet(String key, String item) {
        return this.redisTemplate.opsForHash().get((Object)key, (Object)item);
    }

    public Mono<Boolean> hashSet(String key, Map<String, Object> map) {
        return this.redisTemplate.opsForHash().putAll((Object)key, map);
    }

    public Mono<Boolean> hashSet(String key, Map<String, Object> map, Duration time) {
        return this.redisTemplate.opsForHash().putAll((Object)key, map).flatMap(flag -> this.expire(key, time));
    }

    public Flux<Map.Entry<Object, Object>> hmget(String key) {
        return this.redisTemplate.opsForHash().entries((Object)key);
    }
}

