package me.youm.core.rocket.listen;

import com.aliyun.openservices.ons.api.order.MessageOrderListener;
import me.youm.core.rocket.config.RocketConfig;

/**
 * @author youta
 */
public abstract class MyMessageOrderListener extends RocketConfig implements MessageOrderListener {

    private Integer RETRY_TIMES = 10;

    /**
     * 是否可以重试 10 次
     *
     * @param runTime 当前执行次数
     * @return Boolean 是否重试
     */
    public Boolean canRetryFiveTimes(int runTime) {
        return this.canRetryTimes(runTime, RETRY_TIMES);
    }

    /**
     * 是否可以重试;
     *
     * @param runTime    当前执行次数
     * @param retryTimes 重试次数
     */
    public Boolean canRetryTimes(int runTime, int retryTimes) {
        if (runTime < retryTimes) {
            return true;
        }
        return false;
    }
}
