package me.youm.core.rocket.manager;

import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.order.OrderAction;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import me.youm.core.common.exception.RocketMqException;
import me.youm.core.rocket.RocketMqClient;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Optional;

/**
 * @author youta
 */
@Service
@AllArgsConstructor
@Slf4j
public class RocketMqManager {

    private final List<RocketMqClient> clients;

    public Optional<RocketMqClient> initialize(String tag) {

        return this.clients.stream()
                .filter(client -> client.getTag().equals(tag))
                .findAny();
    }

    public OrderAction consume(Message message, boolean canRetry) {
        RocketMqClient client = null;
        try {
             client = this.initialize(message.getTag()).orElseThrow(() -> new RocketMqException("初始化生产者处理者失败"));
        }catch (Exception e){
            log.error("初始化生产者处理者失败",e);
            throw new RocketMqException("初始化生产者处理者失败");
        }
        if (client ==null){
            log.warn("missing client by this tag [{}]",message.getTag());
            return OrderAction.Success;
        }
        String response = new String(message.getBody());
        OrderAction action;
        try {
            action = client.execute(response);
        } catch (Exception e) {
            log.error("rocket mq process error", e);
            action = OrderAction.Suspend;
        }
        if (OrderAction.Suspend.equals(action) && canRetry) {
            return OrderAction.Suspend;
        }
        return OrderAction.Success;
    }

}
